/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import thedarkcolour.exdeorum.registry.ENumberProviders;

public record SummationGenerator(NumberProvider[] providers) implements NumberProvider
{
    public float getFloat(LootContext context) {
        float sum = 0.0f;
        for (NumberProvider provider : this.providers) {
            sum += provider.getFloat(context);
        }
        return sum;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)ENumberProviders.SUMMATION.get();
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SummationGenerator> {
        public void serialize(JsonObject json, SummationGenerator value, JsonSerializationContext ctx) {
            JsonArray array = new JsonArray();
            for (NumberProvider provider : value.providers) {
                array.add(ctx.serialize((Object)provider, NumberProvider.class));
            }
            json.add("values", (JsonElement)array);
        }

        public SummationGenerator deserialize(JsonObject json, JsonDeserializationContext ctx) {
            JsonArray valuesJson = GsonHelper.getAsJsonArray((JsonObject)json, (String)"values");
            NumberProvider[] providers = new NumberProvider[valuesJson.size()];
            int i = 0;
            for (JsonElement valueJson : valuesJson) {
                providers[i++] = (NumberProvider)ctx.deserialize(valueJson, NumberProvider.class);
            }
            return new SummationGenerator(providers);
        }
    }
}

