/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.material.MaterialRegistry;
import thedarkcolour.exdeorum.material.SoundTypeResolver;

public class MaterialParser {
    private final JsonObject json;
    private final Path jsonPath;
    @Nullable
    private final MaterialRegistry<?> registry;
    boolean error;

    public MaterialParser(JsonObject json, Path jsonPath, @Nullable MaterialRegistry<?> registry) {
        this.json = json;
        this.jsonPath = jsonPath;
        this.registry = registry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SoundType getSoundType() {
        if (this.json.has("sound_type")) {
            JsonElement soundTypeJson = this.json.get("sound_type");
            if (soundTypeJson.isJsonPrimitive()) {
                String soundTypeString = soundTypeJson.getAsString();
                SoundType soundType = SoundTypeResolver.VANILLA_SOUND_TYPES.get(soundTypeString);
                if (soundType != null) return soundType;
                ExDeorum.LOGGER.error("Unknown sound type \"{}\" for material {}", (Object)soundTypeString, (Object)this.jsonPath);
                this.error = true;
                return SoundType.WOOD;
            } else {
                if (soundTypeJson instanceof JsonObject) {
                    JsonObject soundTypeObj = (JsonObject)soundTypeJson;
                    if (!soundTypeObj.has("break_sound") || !soundTypeObj.has("step_sound") || !soundTypeObj.has("place_sound") || !soundTypeObj.has("hit_sound") || !soundTypeObj.has("fall_sound")) return SoundType.WOOD;
                    return new ForgeSoundType(1.0f, 1.0f, (Supplier)RegistryObject.create((ResourceLocation)new ResourceLocation(soundTypeObj.get("break_sound").getAsString()), (ResourceKey)Registries.SOUND_EVENT, (String)"exdeorum"), (Supplier)RegistryObject.create((ResourceLocation)new ResourceLocation(soundTypeObj.get("step_sound").getAsString()), (ResourceKey)Registries.SOUND_EVENT, (String)"exdeorum"), (Supplier)RegistryObject.create((ResourceLocation)new ResourceLocation(soundTypeObj.get("place_sound").getAsString()), (ResourceKey)Registries.SOUND_EVENT, (String)"exdeorum"), (Supplier)RegistryObject.create((ResourceLocation)new ResourceLocation(soundTypeObj.get("hit_sound").getAsString()), (ResourceKey)Registries.SOUND_EVENT, (String)"exdeorum"), (Supplier)RegistryObject.create((ResourceLocation)new ResourceLocation(soundTypeObj.get("fall_sound").getAsString()), (ResourceKey)Registries.SOUND_EVENT, (String)"exdeorum"));
                }
                ExDeorum.LOGGER.error("Unable to parse sound type for material {}", (Object)this.jsonPath);
                this.error = true;
            }
            return SoundType.WOOD;
        } else {
            ExDeorum.LOGGER.error("Missing sound_type property for material {}", (Object)this.jsonPath);
            this.error = true;
        }
        return SoundType.WOOD;
    }

    public float getStrength() {
        if (this.json.has("strength")) {
            JsonElement strengthJson = this.json.get("strength");
            if (strengthJson.isJsonPrimitive()) {
                try {
                    return strengthJson.getAsFloat();
                }
                catch (NumberFormatException e) {
                    ExDeorum.LOGGER.error("Failed to parse strength property for material {} with value {}", (Object)this.jsonPath, (Object)strengthJson.getAsString());
                    this.error = true;
                }
            } else {
                ExDeorum.LOGGER.error("Failed to parse strength property for material {}: not a number", (Object)this.jsonPath);
                this.error = true;
            }
        } else {
            if (this.registry == DefaultMaterials.SIEVES) {
                return 2.0f;
            }
            ExDeorum.LOGGER.error("Missing strength property for material {}", (Object)this.jsonPath);
            this.error = true;
        }
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMapColor() {
        if (this.json.has("map_color")) {
            JsonElement jsonElement = this.json.get("map_color");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive prim = (JsonPrimitive)jsonElement;
                int mapColor = prim.getAsInt();
                if (64 > mapColor && mapColor >= 0) return mapColor;
                ExDeorum.LOGGER.error("Failed to parse map_color property for material {}: value must be in [0,64), found {}", (Object)this.jsonPath, (Object)mapColor);
                this.error = true;
                return 0;
            } else {
                ExDeorum.LOGGER.error("Failed to parse map_color property for material {}: not a number", (Object)this.jsonPath);
                this.error = true;
            }
            return 0;
        } else {
            ExDeorum.LOGGER.error("Missing map_color property for material {}", (Object)this.jsonPath);
            this.error = true;
        }
        return 0;
    }

    public boolean getOptionalBoolean(String key) {
        JsonPrimitive prim;
        JsonElement jsonElement = this.json.get(key);
        return jsonElement instanceof JsonPrimitive && (prim = (JsonPrimitive)jsonElement).isBoolean() && prim.getAsBoolean();
    }

    public String getRequiredModId() {
        JsonPrimitive prim;
        JsonElement jsonElement = this.json.get("required_mod_id");
        if (jsonElement instanceof JsonPrimitive && (prim = (JsonPrimitive)jsonElement).isString()) {
            return prim.getAsString();
        }
        return "exdeorum";
    }
}

