/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.network.NetworkHandler;

public abstract class AbstractMachineMenu<M extends AbstractMachineBlockEntity<M>>
extends AbstractContainerMenu {
    protected static final int PLAYER_SLOTS = 36;
    @Nullable
    private final ServerPlayer player;
    public final M machine;
    public int prevEnergy;

    protected AbstractMachineMenu(MenuType<?> pMenuType, int pContainerId, Inventory playerInventory, M machine) {
        super(pMenuType, pContainerId);
        ServerPlayer serverPlayer;
        this.machine = machine;
        Player player = playerInventory.player;
        this.player = player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
    }

    protected static <M extends AbstractMachineBlockEntity<M>> M readPayload(Inventory playerInventory, FriendlyByteBuf data) {
        AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)playerInventory.player.level().getBlockEntity(data.readBlockPos());
        machine.setRedstoneMode(data.readByte());
        return (M)((Object)machine);
    }

    protected final void addPlayerSlots(Inventory playerInventory, int startY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, startY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, startY + 58));
        }
    }

    public void setClientProperty(int index, int value) {
        if (index == 0) {
            this.prevEnergy = value;
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.player != null) {
            this.syncProperties(this.player);
        }
    }

    public void broadcastFullState() {
        super.broadcastFullState();
        if (this.player != null) {
            this.syncProperties(this.player);
        }
    }

    protected void syncProperties(ServerPlayer player) {
        if (this.prevEnergy != ((AbstractMachineBlockEntity)((Object)this.machine)).energy.getEnergyStored()) {
            this.prevEnergy = ((AbstractMachineBlockEntity)((Object)this.machine)).energy.getEnergyStored();
            NetworkHandler.sendMenuProperty(player, this.containerId, 0, this.prevEnergy);
        }
    }

    public boolean clickMenuButton(Player pPlayer, int id) {
        if (0 <= id && id < 3) {
            ((AbstractMachineBlockEntity)((Object)this.machine)).setRedstoneMode(id);
            return true;
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return ((AbstractMachineBlockEntity)((Object)this.machine)).stillValid(player);
    }
}

