/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import thedarkcolour.exdeorum.network.MenuPropertyMessage;
import thedarkcolour.exdeorum.network.PlayerDataMessage;
import thedarkcolour.exdeorum.network.VisualUpdateMessage;
import thedarkcolour.exdeorum.network.VoidWorldMessage;

public final class NetworkHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("exdeorum", "channel"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        CHANNEL.registerMessage(0, VoidWorldMessage.class, VoidWorldMessage::encode, VoidWorldMessage::decode, VoidWorldMessage::handle);
        CHANNEL.registerMessage(1, PlayerDataMessage.class, (msg, buffer) -> {}, buffer -> new PlayerDataMessage(), PlayerDataMessage::handle);
        CHANNEL.registerMessage(2, VisualUpdateMessage.class, VisualUpdateMessage::encode, VisualUpdateMessage::decode, VisualUpdateMessage::handle);
        CHANNEL.registerMessage(3, MenuPropertyMessage.class, MenuPropertyMessage::encode, MenuPropertyMessage::decode, MenuPropertyMessage::handle);
    }

    public static void sendVoidWorld(ServerPlayer pPlayer) {
        CHANNEL.sendTo((Object)new VoidWorldMessage(), pPlayer.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendRecipeCacheReset(ServerPlayer player) {
        CHANNEL.sendTo((Object)new PlayerDataMessage(), player.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
    }

    static void handle(Supplier<NetworkEvent.Context> ctxSupplier, Consumer<NetworkEvent.Context> handler) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> handler.accept(ctx));
        ctx.setPacketHandled(true);
    }

    public static void sendMenuProperty(ServerPlayer player, int containerId, int index, int prevSieveEnergy) {
        CHANNEL.sendTo((Object)new MenuPropertyMessage(containerId, index, prevSieveEnergy), player.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
    }
}

