/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.network.ClientMessageHandler;
import thedarkcolour.exdeorum.network.NetworkHandler;

class VisualUpdateMessage {
    final BlockEntityType<?> blockEntityType;
    final BlockPos pos;
    @Nullable
    private final EBlockEntity blockEntity;
    @Nullable
    final FriendlyByteBuf payload;

    public VisualUpdateMessage(BlockPos pos, @Nullable EBlockEntity blockEntity, @Nullable FriendlyByteBuf payload) {
        this.pos = pos;
        this.blockEntity = blockEntity;
        this.payload = payload;
        this.blockEntityType = payload == null ? blockEntity.getType() : (BlockEntityType)payload.readById((IdMap)BuiltInRegistries.BLOCK_ENTITY_TYPE);
    }

    public static void encode(VisualUpdateMessage msg, FriendlyByteBuf buffer) {
        buffer.writeBlockPos(msg.pos);
        buffer.writeId((IdMap)BuiltInRegistries.BLOCK_ENTITY_TYPE, msg.blockEntityType);
        msg.blockEntity.writeVisualData(buffer);
    }

    public static VisualUpdateMessage decode(FriendlyByteBuf buffer) {
        return new VisualUpdateMessage(buffer.readBlockPos(), null, buffer);
    }

    public static void handle(VisualUpdateMessage msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkHandler.handle(ctxSupplier, (NetworkEvent.Context ctx) -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientMessageHandler.handleVisualUpdate(msg)));
    }
}

