/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.network.NetworkHandler;
import thedarkcolour.exdeorum.network.VisualUpdateMessage;

public class VisualUpdateTracker {
    private static final Map<LevelChunk, Set<BlockPos>> UPDATES = new WeakHashMap<LevelChunk, Set<BlockPos>>();

    public static void sendVisualUpdate(EBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level != null && !level.isClientSide) {
            Set<BlockPos> updatesList;
            LevelChunk dimension = level.getChunkAt(blockEntity.getBlockPos());
            if (!UPDATES.containsKey(dimension)) {
                updatesList = new HashSet<BlockPos>();
                UPDATES.put(dimension, updatesList);
            } else {
                updatesList = UPDATES.get(dimension);
            }
            updatesList.add(blockEntity.getBlockPos());
        }
    }

    public static void syncVisualUpdates() {
        for (Map.Entry<LevelChunk, Set<BlockPos>> entry : UPDATES.entrySet()) {
            Set<BlockPos> pendingUpdates = entry.getValue();
            for (BlockPos updatePos : pendingUpdates) {
                LevelChunk chunk = entry.getKey();
                BlockEntity blockEntity = chunk.getBlockEntity(updatePos);
                if (!(blockEntity instanceof EBlockEntity)) continue;
                EBlockEntity blockEntity2 = (EBlockEntity)blockEntity;
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(entry::getKey), (Object)new VisualUpdateMessage(updatePos, blockEntity2, null));
            }
            pendingUpdates.clear();
        }
    }
}

