/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BlockPredicate
extends Predicate<BlockState> {
    public static final byte SINGLE_BLOCK = 0;
    public static final byte BLOCK_STATE = 1;
    public static final byte BLOCK_TAG = 2;

    public JsonObject toJson();

    public void toNetwork(FriendlyByteBuf var1);

    public Stream<BlockState> possibleStates();

    public static BlockPredicate singleBlock(Block block) {
        return new SingleBlockPredicate(block);
    }

    public static BlockPredicate blockState(Block block, StatePropertiesPredicate properties) {
        return new BlockStatePredicate(block, properties);
    }

    public static BlockPredicate blockTag(TagKey<Block> tag) {
        return new TagPredicate(tag);
    }

    @Nullable
    public static BlockPredicate fromJson(@Nullable JsonObject json) {
        if (json == null) {
            return null;
        }
        if (json.has("block")) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(json.get("block").getAsString()));
            if (block == Blocks.AIR) {
                return null;
            }
            if (json.has("state")) {
                return new BlockStatePredicate(block, StatePropertiesPredicate.fromJson((JsonElement)json.get("state")));
            }
            return new SingleBlockPredicate(block);
        }
        if (json.has("block_tag")) {
            return new TagPredicate((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation(json.get("block_tag").getAsString())));
        }
        return null;
    }

    @Nullable
    public static BlockPredicate fromNetwork(FriendlyByteBuf buffer) {
        return switch (buffer.readByte()) {
            case 0 -> new SingleBlockPredicate((Block)buffer.readById((IdMap)BuiltInRegistries.BLOCK));
            case 1 -> new BlockStatePredicate((Block)buffer.readById((IdMap)BuiltInRegistries.BLOCK), StatePropertiesPredicate.fromJson((JsonElement)JsonParser.parseString((String)buffer.readUtf())));
            case 2 -> new TagPredicate((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)buffer.readResourceLocation()));
            default -> null;
        };
    }

    public record SingleBlockPredicate(Block block) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(0);
            buffer.writeId((IdMap)BuiltInRegistries.BLOCK, (Object)this.block);
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.block);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.getStateDefinition().getPossibleStates().stream();
        }
    }

    public record BlockStatePredicate(Block block, StatePropertiesPredicate properties) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
            json.add("state", this.properties.serializeToJson());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(1);
            buffer.writeId((IdMap)BuiltInRegistries.BLOCK, (Object)this.block);
            buffer.writeUtf(this.properties.serializeToJson().toString());
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.block) && this.properties.matches(state);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.getStateDefinition().getPossibleStates().stream().filter(arg_0 -> ((StatePropertiesPredicate)this.properties).matches(arg_0));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockStatePredicate that = (BlockStatePredicate)o;
            return Objects.equals(this.block, that.block) && Objects.equals(this.properties.serializeToJson(), that.properties.serializeToJson());
        }
    }

    public record TagPredicate(TagKey<Block> tag) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block_tag", this.tag.location().toString());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(2);
            buffer.writeResourceLocation(this.tag.location());
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.tag);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).spliterator(), false).filter(holder -> holder.is(this.tag)).flatMap(holder -> ((Block)holder.get()).getStateDefinition().getPossibleStates().stream());
        }
    }
}

