/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.client.ClientsideCode;
import thedarkcolour.exdeorum.compat.PreferredOres;
import thedarkcolour.exdeorum.item.CompressedHammerItem;
import thedarkcolour.exdeorum.item.HammerItem;
import thedarkcolour.exdeorum.loot.SummationGenerator;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.barrel.BarrelCompostRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FluidTransformationRecipe;
import thedarkcolour.exdeorum.recipe.cache.BarrelFluidMixingRecipeCache;
import thedarkcolour.exdeorum.recipe.cache.CrookRecipeCache;
import thedarkcolour.exdeorum.recipe.cache.CrucibleHeatRecipeCache;
import thedarkcolour.exdeorum.recipe.cache.FluidTransformationRecipeCache;
import thedarkcolour.exdeorum.recipe.cache.SieveRecipeCache;
import thedarkcolour.exdeorum.recipe.cache.SingleIngredientRecipeCache;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;
import thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.recipe.sieve.CompressedSieveRecipe;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.registry.ENumberProviders;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public final class RecipeUtil {
    private static final int CONSTANT_TYPE = 1;
    private static final int UNIFORM_TYPE = 2;
    private static final int BINOMIAL_TYPE = 3;
    private static final int SUMMATION_TYPE = 4;
    private static final int UNKNOWN_TYPE = 99;
    private static SingleIngredientRecipeCache<BarrelCompostRecipe> barrelCompostRecipeCache;
    private static SingleIngredientRecipeCache<CrucibleRecipe> lavaCrucibleRecipeCache;
    private static SingleIngredientRecipeCache<CrucibleRecipe> waterCrucibleRecipeCache;
    private static SingleIngredientRecipeCache<HammerRecipe> hammerRecipeCache;
    private static SingleIngredientRecipeCache<CompressedHammerRecipe> compressedHammerRecipeCache;
    private static SieveRecipeCache<SieveRecipe> sieveRecipeCache;
    private static SieveRecipeCache<CompressedSieveRecipe> compressedSieveRecipeCache;
    private static BarrelFluidMixingRecipeCache barrelFluidMixingRecipeCache;
    private static FluidTransformationRecipeCache fluidTransformationRecipeCache;
    private static CrookRecipeCache crookRecipeCache;
    private static CrucibleHeatRecipeCache crucibleHeatRecipeCache;

    public static void reload(RecipeManager recipes) {
        barrelCompostRecipeCache = new SingleIngredientRecipeCache<BarrelCompostRecipe>(recipes, (Supplier<RecipeType<BarrelCompostRecipe>>)ERecipeTypes.BARREL_COMPOST);
        lavaCrucibleRecipeCache = new SingleIngredientRecipeCache<CrucibleRecipe>(recipes, (Supplier<RecipeType<CrucibleRecipe>>)ERecipeTypes.LAVA_CRUCIBLE);
        waterCrucibleRecipeCache = new SingleIngredientRecipeCache<CrucibleRecipe>(recipes, (Supplier<RecipeType<CrucibleRecipe>>)ERecipeTypes.WATER_CRUCIBLE);
        hammerRecipeCache = new SingleIngredientRecipeCache<HammerRecipe>(recipes, (Supplier<RecipeType<HammerRecipe>>)ERecipeTypes.HAMMER).trackAllRecipes();
        compressedHammerRecipeCache = new SingleIngredientRecipeCache<CompressedHammerRecipe>(recipes, (Supplier<RecipeType<CompressedHammerRecipe>>)ERecipeTypes.COMPRESSED_HAMMER).trackAllRecipes();
        sieveRecipeCache = new SieveRecipeCache<SieveRecipe>(recipes, (Supplier<RecipeType<SieveRecipe>>)ERecipeTypes.SIEVE);
        compressedSieveRecipeCache = new SieveRecipeCache<CompressedSieveRecipe>(recipes, (Supplier<RecipeType<CompressedSieveRecipe>>)ERecipeTypes.COMPRESSED_SIEVE);
        barrelFluidMixingRecipeCache = new BarrelFluidMixingRecipeCache(recipes);
        fluidTransformationRecipeCache = new FluidTransformationRecipeCache(recipes);
        crookRecipeCache = new CrookRecipeCache(recipes);
        crucibleHeatRecipeCache = new CrucibleHeatRecipeCache(recipes);
        HammerItem.refreshValidBlocks();
        CompressedHammerItem.refreshValidBlocks();
    }

    public static void unload() {
        barrelCompostRecipeCache = null;
        lavaCrucibleRecipeCache = null;
        waterCrucibleRecipeCache = null;
        hammerRecipeCache = null;
        compressedHammerRecipeCache = null;
        sieveRecipeCache = null;
        barrelFluidMixingRecipeCache = null;
        fluidTransformationRecipeCache = null;
        crookRecipeCache = null;
        crucibleHeatRecipeCache = null;
    }

    public static List<SieveRecipe> getSieveRecipes(Item mesh, ItemStack item) {
        return sieveRecipeCache.getRecipe(mesh, item);
    }

    public static List<CompressedSieveRecipe> getCompressedSieveRecipes(Item mesh, ItemStack item) {
        return compressedSieveRecipeCache.getRecipe(mesh, item);
    }

    @Nullable
    public static CrucibleRecipe getLavaCrucibleRecipe(ItemStack item) {
        return lavaCrucibleRecipeCache.getRecipe(item);
    }

    @Nullable
    public static CrucibleRecipe getWaterCrucibleRecipe(ItemStack item) {
        return waterCrucibleRecipeCache.getRecipe(item);
    }

    @Nullable
    public static BarrelCompostRecipe getBarrelCompostRecipe(ItemStack item) {
        return barrelCompostRecipeCache.getRecipe(item);
    }

    @Nullable
    public static HammerRecipe getHammerRecipe(Item item) {
        return hammerRecipeCache.getRecipe(item);
    }

    public static Collection<HammerRecipe> getCachedHammerRecipes() {
        return hammerRecipeCache.getAllRecipes();
    }

    @Nullable
    public static HammerRecipe getCompressedHammerRecipe(Item itemForm) {
        return compressedHammerRecipeCache.getRecipe(itemForm);
    }

    public static Collection<CompressedHammerRecipe> getCachedCompressedHammerRecipes() {
        return compressedHammerRecipeCache.getAllRecipes();
    }

    public static <C extends Container, T extends Recipe<C>> Collection<T> byType(RecipeManager manager, RecipeType<T> type) {
        return manager.byType(type).values();
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server == null ? (FMLEnvironment.dist == Dist.CLIENT ? ClientsideCode.getRecipeManager() : null) : server.getRecipeManager();
    }

    public static Ingredient readIngredient(JsonObject json, String key) {
        if (GsonHelper.isArrayNode((JsonObject)json, (String)key)) {
            return Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonArray((JsonObject)json, (String)key));
        }
        return Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)json, (String)key));
    }

    public static Item readItem(JsonObject json, String key) {
        return CraftingHelper.getItem((String)GsonHelper.getAsString((JsonObject)json, (String)key), (boolean)true);
    }

    public static Fluid readFluid(JsonObject json, String key) {
        String fluidName = GsonHelper.getAsString((JsonObject)json, (String)key);
        ResourceLocation fluidKey = new ResourceLocation(fluidName);
        if (!ForgeRegistries.FLUIDS.containsKey(fluidKey)) {
            throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey);
        if (fluid == Fluids.EMPTY) {
            throw new JsonSyntaxException("Invalid Fluid: " + fluidName);
        }
        return Objects.requireNonNull(fluid);
    }

    public static NumberProvider readNumberProvider(JsonObject json, String key) {
        JsonElement obj = json.get(key);
        return (NumberProvider)LootDataType.PREDICATE.parser().fromJson(obj, NumberProvider.class);
    }

    public static void toNetworkNumberProvider(FriendlyByteBuf buffer, NumberProvider provider) {
        if (provider.getType() == NumberProviders.CONSTANT) {
            buffer.writeByte(1);
            buffer.writeFloat(((ConstantValue)provider).value);
        } else if (provider.getType() == NumberProviders.UNIFORM) {
            UniformGenerator uniform = (UniformGenerator)provider;
            buffer.writeByte(2);
            RecipeUtil.toNetworkNumberProvider(buffer, uniform.min);
            RecipeUtil.toNetworkNumberProvider(buffer, uniform.max);
        } else if (provider.getType() == NumberProviders.BINOMIAL) {
            BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)provider;
            buffer.writeByte(3);
            RecipeUtil.toNetworkNumberProvider(buffer, binomial.n);
            RecipeUtil.toNetworkNumberProvider(buffer, binomial.p);
        } else if (provider.getType() == ENumberProviders.SUMMATION.get()) {
            SummationGenerator summation = (SummationGenerator)provider;
            NumberProvider[] providers = summation.providers();
            int length = providers.length;
            buffer.writeByte(4);
            buffer.writeByte(length);
            for (int i = 0; i < length; ++i) {
                RecipeUtil.toNetworkNumberProvider(buffer, providers[i]);
            }
        } else {
            buffer.writeByte(99);
        }
    }

    public static NumberProvider fromNetworkNumberProvider(FriendlyByteBuf buffer) {
        return switch (buffer.readByte()) {
            case 1 -> ConstantValue.exactly((float)buffer.readFloat());
            case 2 -> new UniformGenerator(RecipeUtil.fromNetworkNumberProvider(buffer), RecipeUtil.fromNetworkNumberProvider(buffer));
            case 3 -> new BinomialDistributionGenerator(RecipeUtil.fromNetworkNumberProvider(buffer), RecipeUtil.fromNetworkNumberProvider(buffer));
            case 4 -> {
                int length = buffer.readByte();
                NumberProvider[] providers = new NumberProvider[length];
                for (int i = 0; i < length; ++i) {
                    providers[i] = RecipeUtil.fromNetworkNumberProvider(buffer);
                }
                yield new SummationGenerator(providers);
            }
            default -> ConstantValue.exactly((float)1.0f);
        };
    }

    public static boolean areIngredientsEqual(Ingredient first, Ingredient second) {
        if (first == second) {
            return true;
        }
        if (first.isVanilla() && second.isVanilla()) {
            ObjectArrayList firstValues = new ObjectArrayList((Object[])first.values);
            ObjectArrayList secondValues = new ObjectArrayList((Object[])second.values);
            if (firstValues.size() == secondValues.size()) {
                block0: for (int i = 0; i < firstValues.size(); ++i) {
                    Ingredient.Value firstValue = (Ingredient.Value)firstValues.get(i);
                    for (int j = 0; j < firstValues.size(); ++j) {
                        if (!RecipeUtil.areValuesEqual(firstValue, (Ingredient.Value)secondValues.get(j))) continue;
                        firstValues.remove(i);
                        secondValues.remove(j);
                        --i;
                        continue block0;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areValuesEqual(Ingredient.Value firstValue, Ingredient.Value secondValue) {
        Class<?> secondKlass;
        Class<?> firstKlass = firstValue.getClass();
        if (firstKlass == (secondKlass = secondValue.getClass())) {
            if (firstKlass == Ingredient.ItemValue.class) {
                return ItemStack.matches((ItemStack)((Ingredient.ItemValue)firstValue).item, (ItemStack)((Ingredient.ItemValue)secondValue).item);
            }
            if (firstKlass == Ingredient.TagValue.class) {
                return ((Ingredient.TagValue)firstValue).tag == ((Ingredient.TagValue)secondValue).tag;
            }
            Collection firstItems = firstValue.getItems();
            Collection secondItems = secondValue.getItems();
            int len = firstItems.size();
            if (len == secondItems.size()) {
                Iterator firstIter = firstItems.iterator();
                Iterator secondIter = secondItems.iterator();
                while (firstIter.hasNext()) {
                    if (ItemStack.matches((ItemStack)((ItemStack)firstIter.next()), (ItemStack)((ItemStack)secondIter.next()))) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isCompostable(ItemStack stack) {
        return barrelCompostRecipeCache != null && barrelCompostRecipeCache.getRecipe(stack) != null;
    }

    @Nullable
    public static BarrelMixingRecipe getBarrelMixingRecipe(RecipeManager recipes, ItemStack stack, FluidStack fluid) {
        for (BarrelMixingRecipe recipe : RecipeUtil.byType(recipes, (RecipeType)ERecipeTypes.BARREL_MIXING.get())) {
            if (!recipe.matches(stack, fluid)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static BarrelFluidMixingRecipe getFluidMixingRecipe(FluidStack base, Fluid additive) {
        BarrelFluidMixingRecipe recipe = barrelFluidMixingRecipeCache.getRecipe(base.getFluid(), additive);
        if (recipe != null && base.getAmount() >= recipe.baseFluidAmount) {
            return recipe;
        }
        return null;
    }

    @Nullable
    public static FluidTransformationRecipe getFluidTransformationRecipe(Fluid baseFluid, BlockState catalystState) {
        if (baseFluid != Fluids.EMPTY) {
            if (fluidTransformationRecipeCache == null) {
                fluidTransformationRecipeCache = new FluidTransformationRecipeCache(Objects.requireNonNull(RecipeUtil.getRecipeManager(), "Error: Please report to ExDeorum GitHub page with your debug.log file!"));
            }
            return fluidTransformationRecipeCache.getRecipe(baseFluid, catalystState);
        }
        return null;
    }

    public static double getExpectedValue(NumberProvider provider) {
        if (provider instanceof ConstantValue) {
            ConstantValue constant = (ConstantValue)provider;
            return constant.value;
        }
        if (provider instanceof UniformGenerator) {
            UniformGenerator uniform = (UniformGenerator)provider;
            return RecipeUtil.getExpectedValue(uniform.min) + RecipeUtil.getExpectedValue(uniform.max) / 2.0;
        }
        if (provider instanceof BinomialDistributionGenerator) {
            BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)provider;
            return RecipeUtil.getExpectedValue(binomial.n) * RecipeUtil.getExpectedValue(binomial.p);
        }
        if (provider instanceof SummationGenerator) {
            SummationGenerator summation = (SummationGenerator)provider;
            double avgSum = 0.0;
            for (NumberProvider child : summation.providers()) {
                double expectedValue = RecipeUtil.getExpectedValue(child);
                if (expectedValue == -1.0) {
                    return -1.0;
                }
                avgSum += expectedValue;
            }
            return avgSum;
        }
        return -1.0;
    }

    @Nullable
    public static BlockPredicate readBlockPredicate(ResourceLocation recipeId, JsonObject json, String key) {
        BlockPredicate blockPredicate = BlockPredicate.fromJson(json.getAsJsonObject(key));
        if (blockPredicate == null) {
            ExDeorum.LOGGER.error("Invalid {} for recipe {}, refer to Ex Deorum documentation for syntax: {}", new Object[]{key, recipeId, json.getAsJsonObject(key)});
        }
        return blockPredicate;
    }

    @Nullable
    public static BlockPredicate readBlockPredicateNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        BlockPredicate blockPredicate = BlockPredicate.fromNetwork(buffer);
        if (blockPredicate == null) {
            ExDeorum.LOGGER.error("Failed to read block_predicate from network for recipe {}", (Object)recipeId);
        }
        return blockPredicate;
    }

    public static boolean isTagEmpty(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getTag(tag).map(set -> !set.iterator().hasNext()).orElse(PreferredOres.getPreferredOre(tag) == Items.AIR);
    }

    public static LootContext emptyLootContext(ServerLevel level) {
        return new LootContext.Builder(new LootParams(level, Map.of(), Map.of(), 0.0f)).create(null);
    }

    public static List<CrookRecipe> getCrookRecipes(BlockState state) {
        return crookRecipeCache.getRecipes(state);
    }

    public static int getHeatValue(BlockState state) {
        return crucibleHeatRecipeCache.getValue(state);
    }

    public static ObjectSet<Object2IntMap.Entry<BlockState>> getHeatSources() {
        return crucibleHeatRecipeCache.getEntries();
    }

    public static FluidStack readFluidStack(JsonObject json, String key) {
        if (json.has(key)) {
            JsonObject fluidJson = json.getAsJsonObject(key);
            if (fluidJson.has("FluidName")) {
                FluidStack stack = new FluidStack(RecipeUtil.readFluid(fluidJson, "FluidName"), GsonHelper.getAsInt((JsonObject)fluidJson, (String)"Amount"));
                if (fluidJson.has("Tag")) {
                    stack.setTag(CraftingHelper.getNBT((JsonElement)fluidJson.get("Tag")));
                }
                return stack;
            }
            FluidStack stack = new FluidStack(RecipeUtil.readFluid(fluidJson, "fluid"), GsonHelper.getAsInt((JsonObject)fluidJson, (String)"amount"));
            if (fluidJson.has("nbt")) {
                stack.setTag(CraftingHelper.getNBT((JsonElement)fluidJson.get("nbt")));
            }
            return stack;
        }
        throw new JsonSyntaxException("Missing fluid");
    }

    public static JsonElement writeFluidStackJson(FluidStack fluidStack) {
        JsonObject object = new JsonObject();
        object.addProperty("fluid", RecipeUtil.getFluidId(fluidStack.getFluid()));
        object.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            object.addProperty("nbt", fluidStack.getTag().getAsString());
        }
        return object;
    }

    public static JsonPrimitive writeBlockState(BlockState state) {
        ResourceLocation registryKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        Collection properties = state.getProperties();
        if (properties.isEmpty()) {
            return new JsonPrimitive(registryKey.toString());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(registryKey);
        builder.append('[');
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            builder.append(property.getName());
            builder.append('=');
            builder.append(property.getName(state.getValue(property)));
            if (!iterator.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        return new JsonPrimitive(builder.toString());
    }

    public static BlockState parseBlockState(String stateString) {
        try {
            return BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)stateString, (boolean)false).blockState();
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState string \"" + stateString + "\"");
        }
    }

    public static String getFluidId(Fluid baseFluid) {
        return BuiltInRegistries.FLUID.getKey((Object)baseFluid).toString();
    }

    public static String writeItemJson(Item result) {
        return BuiltInRegistries.ITEM.getKey((Object)result).toString();
    }

    @Nullable
    public static CompoundTag readNbtTag(JsonObject json, String key) {
        return json.has(key) ? CraftingHelper.getNBT((JsonElement)json.get(key)) : null;
    }
}

