/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public abstract class SingleIngredientRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public final Ingredient ingredient;
    public final boolean dependsOnNbt;

    public SingleIngredientRecipe(ResourceLocation id, Ingredient ingredient) {
        this.id = id;
        this.ingredient = ingredient;
        this.dependsOnNbt = !ingredient.isSimple();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean matches(Container inventory, Level level) {
        return this.ingredient.test(inventory.getItem(0));
    }

    public ItemStack assemble(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.create();
    }
}

