/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.compat.PreferredOres;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class TagResultRecipe {

    public static class Finished
    implements FinishedRecipe {
        private final TagKey<Item> resultTag;
        private final FinishedRecipe recipe;

        public Finished(TagKey<Item> resultTag, FinishedRecipe recipe) {
            this.resultTag = resultTag;
            this.recipe = recipe;
        }

        public void serializeRecipeData(JsonObject json) {
            JsonObject recipeJson = new JsonObject();
            this.recipe.serializeRecipeData(recipeJson);
            recipeJson.addProperty("type", BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)this.recipe.getType()).toString());
            json.addProperty("result_tag", this.resultTag.location().toString());
            json.add("recipe", (JsonElement)recipeJson);
        }

        public ResourceLocation getId() {
            return this.recipe.getId();
        }

        public RecipeSerializer<?> getType() {
            return (RecipeSerializer)ERecipeSerializers.TAG_RESULT.get();
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return this.recipe.serializeAdvancement();
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return this.recipe.getAdvancementId();
        }
    }

    public static class Serializer<T extends Recipe<?>>
    implements RecipeSerializer<T> {
        public T fromJson(ResourceLocation id, JsonObject json) {
            String resultTag = GsonHelper.getAsString((JsonObject)json, (String)"result_tag");
            if (ResourceLocation.isValidResourceLocation((String)resultTag)) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(resultTag));
                Item preferredItem = PreferredOres.getPreferredOre((TagKey<Item>)tag);
                if (preferredItem != Items.AIR) {
                    JsonObject recipeJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)"recipe");
                    if (recipeJson.has("result")) {
                        JsonObject resultJson = GsonHelper.getAsJsonObject((JsonObject)recipeJson, (String)"result");
                        String itemId = preferredItem.builtInRegistryHolder().key().location().toString();
                        resultJson.addProperty("item", itemId);
                        return (T)RecipeManager.fromJson((ResourceLocation)id, (JsonObject)recipeJson);
                    }
                    ExDeorum.LOGGER.error("Skipping recipe {} with unhandled recipe type, \"{}\". Please report to Ex Deorum GitHub.", (Object)id, (Object)recipeJson.get("type").getAsString());
                } else {
                    ExDeorum.LOGGER.info("Skipping recipe {} as ExDeorum could not determine substitute for tag {}", (Object)id, (Object)tag.location());
                }
            } else {
                ExDeorum.LOGGER.error("Invalid resource location for \"result_tag\" in recipe {}", (Object)id);
            }
            return null;
        }

        @Nullable
        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return null;
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        }
    }
}

