/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class WeightedList<T> {
    private final int totalWeight;
    private final Object[] values;
    private final int[] weights;

    private WeightedList(int totalWeight, Object[] values, int[] weights) {
        Preconditions.checkArgument((values.length == weights.length ? 1 : 0) != 0, (Object)"Values and weights arrays are different sizes");
        this.totalWeight = totalWeight;
        this.values = values;
        this.weights = weights;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public T getRandom(RandomSource rand) {
        int chosenIndex = rand.nextInt(this.totalWeight);
        for (int i = 0; i < this.values.length; ++i) {
            if ((chosenIndex -= this.weights[i]) >= 0) continue;
            return (T)this.values[i];
        }
        throw new IllegalStateException("Could not get random element");
    }

    public void toNetwork(FriendlyByteBuf buffer, BiConsumer<FriendlyByteBuf, T> valueWriter) {
        buffer.writeVarInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            valueWriter.accept(buffer, (FriendlyByteBuf)this.values[i]);
            buffer.writeVarInt(this.weights[i]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedList that = (WeightedList)o;
        return Arrays.equals(this.values, that.values) && Arrays.equals(this.weights, that.weights);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + Arrays.hashCode(this.weights);
        return result;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> WeightedList<T> fromNetwork(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> valueReader) {
        int size = buffer.readVarInt();
        Object[] values = new Object[size];
        int[] weights = new int[size];
        int totalWeight = 0;
        for (int i = 0; i < size; ++i) {
            values[i] = Objects.requireNonNull(valueReader.apply(buffer), "Failed to read weighted list value from network");
            weights[i] = buffer.readVarInt();
            totalWeight += weights[i];
        }
        return new WeightedList<T>(totalWeight, values, weights);
    }

    public JsonArray toJson(Function<T, JsonElement> serializer) {
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.values.length; ++i) {
            JsonElement value = serializer.apply(this.values[i]);
            int weight = this.weights[i];
            JsonObject json = new JsonObject();
            json.add("value", value);
            json.addProperty("weight", (Number)weight);
            array.add((JsonElement)json);
        }
        return array;
    }

    @Nullable
    public static <T> WeightedList<T> fromJson(JsonArray array, Function<JsonElement, @Nullable T> deserializer) {
        Builder<T> list = WeightedList.builder();
        for (JsonElement element : array) {
            if (element instanceof JsonObject) {
                JsonObject obj = (JsonObject)element;
                int weight = GsonHelper.getAsInt((JsonObject)obj, (String)"weight");
                T value = deserializer.apply(obj.get("value"));
                if (value == null) {
                    return null;
                }
                list.add(weight, value);
                continue;
            }
            throw new JsonSyntaxException("Invalid weighted list entry");
        }
        return list.build();
    }

    public static class Builder<T> {
        private final ArrayList<T> values = new ArrayList();
        private final IntArrayList weights = new IntArrayList();
        private int totalWeight;

        public Builder<T> add(int weight, T element) {
            this.totalWeight += weight;
            this.values.add(element);
            this.weights.add(weight);
            return this;
        }

        public WeightedList<T> build() {
            return new WeightedList(this.totalWeight, this.values.toArray(), this.weights.toArray(new int[0]));
        }
    }
}

