/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class BarrelCompostRecipe
extends SingleIngredientRecipe {
    private final int volume;

    public BarrelCompostRecipe(ResourceLocation id, Ingredient ingredient, int volume) {
        super(id, ingredient);
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_COMPOST.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_COMPOST.get();
    }

    public static class Serializer
    implements RecipeSerializer<BarrelCompostRecipe> {
        public BarrelCompostRecipe fromJson(ResourceLocation name, JsonObject json) {
            Ingredient ingredient = RecipeUtil.readIngredient(json, "ingredient");
            int volume = GsonHelper.getAsInt((JsonObject)json, (String)"volume");
            return new BarrelCompostRecipe(name, ingredient, volume);
        }

        public void toNetwork(FriendlyByteBuf buffer, BarrelCompostRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            buffer.writeVarInt(recipe.getVolume());
        }

        public BarrelCompostRecipe fromNetwork(ResourceLocation name, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            int volume = buffer.readVarInt();
            return new BarrelCompostRecipe(name, ingredient, volume);
        }
    }
}

