/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import thedarkcolour.exdeorum.recipe.EFinishedRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class FinishedBarrelFluidMixingRecipe
extends EFinishedRecipe {
    private final Fluid baseFluid;
    private final int baseFluidAmount;
    private final Fluid additiveFluid;
    private final Item result;
    private final boolean consumesAdditive;

    public FinishedBarrelFluidMixingRecipe(ResourceLocation id, Fluid baseFluid, int baseFluidAmount, Fluid additiveFluid, Item result, boolean consumesAdditive) {
        super(id);
        this.baseFluid = baseFluid;
        this.baseFluidAmount = baseFluidAmount;
        this.additiveFluid = additiveFluid;
        this.result = result;
        this.consumesAdditive = consumesAdditive;
    }

    public void serializeRecipeData(JsonObject json) {
        json.addProperty("base_fluid", RecipeUtil.getFluidId(this.baseFluid));
        json.addProperty("base_fluid_amount", (Number)this.baseFluidAmount);
        json.addProperty("additive_fluid", RecipeUtil.getFluidId(this.additiveFluid));
        json.addProperty("consumes_additive", Boolean.valueOf(this.consumesAdditive));
        json.addProperty("result", RecipeUtil.writeItemJson(this.result));
    }

    public RecipeSerializer<?> getType() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_MIXING.get();
    }
}

