/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.EFinishedRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.WeightedList;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class FinishedFluidTransformationRecipe
extends EFinishedRecipe {
    private final Fluid baseFluid;
    private final Fluid resultFluid;
    private final int resultColor;
    private final BlockPredicate catalyst;
    private final WeightedList<BlockState> byproducts;
    private final int duration;

    public FinishedFluidTransformationRecipe(ResourceLocation id, Fluid baseFluid, Fluid resultFluid, int resultColor, BlockPredicate catalyst, WeightedList<BlockState> byproducts, int duration) {
        super(id);
        this.baseFluid = baseFluid;
        this.resultFluid = resultFluid;
        this.resultColor = resultColor;
        this.catalyst = catalyst;
        this.byproducts = byproducts;
        this.duration = duration;
    }

    public void serializeRecipeData(JsonObject json) {
        json.addProperty("base_fluid", RecipeUtil.getFluidId(this.baseFluid));
        json.addProperty("result_fluid", RecipeUtil.getFluidId(this.resultFluid));
        json.addProperty("result_color", (Number)this.resultColor);
        json.addProperty("duration", (Number)this.duration);
        json.add("catalyst", (JsonElement)this.catalyst.toJson());
        json.add("byproducts", (JsonElement)this.byproducts.toJson(RecipeUtil::writeBlockState));
    }

    public RecipeSerializer<?> getType() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_TRANSFORMATION.get();
    }
}

