/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.WeightedList;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class FluidTransformationRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public final Fluid baseFluid;
    public final Fluid resultFluid;
    public final int resultColor;
    public final BlockPredicate catalyst;
    public final WeightedList<BlockState> byproducts;
    public final int duration;

    public FluidTransformationRecipe(ResourceLocation id, Fluid baseFluid, Fluid resultFluid, int resultColor, BlockPredicate catalyst, WeightedList<BlockState> byproducts, int duration) {
        this.id = id;
        this.baseFluid = baseFluid;
        this.resultFluid = resultFluid;
        this.resultColor = resultColor;
        this.catalyst = catalyst;
        this.byproducts = byproducts;
        this.duration = duration;
    }

    public boolean matches(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_TRANSFORMATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_FLUID_TRANSFORMATION.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidTransformationRecipe that = (FluidTransformationRecipe)o;
        return this.resultColor == that.resultColor && this.duration == that.duration && Objects.equals(this.id, that.id) && Objects.equals(this.baseFluid, that.baseFluid) && Objects.equals(this.resultFluid, that.resultFluid) && Objects.equals(this.catalyst, that.catalyst) && Objects.equals(this.byproducts, that.byproducts);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.baseFluid, this.resultFluid, this.resultColor, this.catalyst, this.byproducts, this.duration);
    }

    public static class Serializer
    implements RecipeSerializer<FluidTransformationRecipe> {
        public FluidTransformationRecipe fromJson(ResourceLocation id, JsonObject json) {
            Fluid baseFluid = RecipeUtil.readFluid(json, "base_fluid");
            Fluid resultFluid = RecipeUtil.readFluid(json, "result_fluid");
            int resultColor = GsonHelper.getAsInt((JsonObject)json, (String)"result_color");
            int duration = GsonHelper.getAsInt((JsonObject)json, (String)"duration");
            BlockPredicate catalyst = RecipeUtil.readBlockPredicate(id, json, "catalyst");
            WeightedList<BlockState> byproducts = WeightedList.fromJson(json.getAsJsonArray("byproducts"), element -> {
                if (element.isJsonPrimitive()) {
                    return RecipeUtil.parseBlockState(element.getAsString());
                }
                return null;
            });
            if (catalyst == null) {
                throw new JsonSyntaxException("Failed to read barrel fluid transformation recipe catalyst");
            }
            if (byproducts == null) {
                throw new JsonSyntaxException("Failed to read barrel fluid transformation recipe byproducts");
            }
            return new FluidTransformationRecipe(id, baseFluid, resultFluid, resultColor, catalyst, byproducts, duration);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidTransformationRecipe recipe) {
            buffer.writeRegistryId(ForgeRegistries.FLUIDS, (Object)recipe.baseFluid);
            buffer.writeRegistryId(ForgeRegistries.FLUIDS, (Object)recipe.resultFluid);
            buffer.writeInt(recipe.resultColor);
            recipe.catalyst.toNetwork(buffer);
            recipe.byproducts.toNetwork(buffer, (FriendlyByteBuf buf, T state) -> buf.writeId((IdMap)Block.BLOCK_STATE_REGISTRY, state));
            buffer.writeVarInt(recipe.duration);
        }

        @Nullable
        public FluidTransformationRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Fluid baseFluid = (Fluid)buffer.readRegistryId();
            Fluid resultFluid = (Fluid)buffer.readRegistryId();
            int resultColor = buffer.readInt();
            BlockPredicate catalyst = RecipeUtil.readBlockPredicateNetwork(id, buffer);
            if (catalyst == null) {
                return null;
            }
            WeightedList<BlockState> byproducts = WeightedList.fromNetwork(buffer, buf -> (BlockState)buf.readById((IdMap)Block.BLOCK_STATE_REGISTRY));
            int duration = buffer.readVarInt();
            return new FluidTransformationRecipe(id, baseFluid, resultFluid, resultColor, catalyst, byproducts, duration);
        }
    }
}

