/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class CrookRecipeCache {
    private RecipeManager recipeManager;
    @Nullable
    private Map<BlockState, List<CrookRecipe>> recipes;

    public CrookRecipeCache(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public List<CrookRecipe> getRecipes(BlockState state) {
        if (this.recipes == null) {
            this.buildRecipes();
        }
        return this.recipes.getOrDefault(state, List.of());
    }

    private void buildRecipes() {
        this.recipes = new HashMap<BlockState, List<CrookRecipe>>();
        HashMap tempRecipes = new HashMap();
        for (CrookRecipe recipe : this.recipeManager.byType((RecipeType)ERecipeTypes.CROOK.get()).values()) {
            recipe.blockPredicate().possibleStates().forEach(state -> tempRecipes.computeIfAbsent(state, key -> new HashSet()).add(recipe));
        }
        HashMap<HashSet, List> dedupeMap = new HashMap<HashSet, List>();
        for (Map.Entry entry : tempRecipes.entrySet()) {
            this.recipes.put((BlockState)entry.getKey(), dedupeMap.computeIfAbsent((HashSet)entry.getValue(), List::copyOf));
        }
        this.recipeManager = null;
    }
}

