/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;

public class SieveRecipeCache<T extends SieveRecipe> {
    private RecipeManager recipeManager;
    private final Supplier<? extends RecipeType<T>> recipeType;
    @Nullable
    private Map<Item, MeshRecipeCache<T>> meshCaches;

    public SieveRecipeCache(RecipeManager recipeManager, Supplier<? extends RecipeType<T>> recipeType) {
        this.recipeManager = recipeManager;
        this.recipeType = recipeType;
    }

    public List<T> getRecipe(Item mesh, ItemStack input) {
        MeshRecipeCache<T> meshCache;
        if (this.meshCaches == null) {
            this.buildRecipes();
        }
        return (meshCache = this.meshCaches.get(mesh)) == null ? List.of() : meshCache.getRecipes(input);
    }

    private void buildRecipes() {
        HashMap<Item, List> tempMap = new HashMap<Item, List>();
        for (SieveRecipe sieveRecipe : this.recipeManager.byType(this.recipeType.get()).values()) {
            tempMap.computeIfAbsent(sieveRecipe.mesh, k -> new ArrayList()).add(sieveRecipe);
        }
        this.meshCaches = new HashMap<Item, MeshRecipeCache<T>>();
        for (Map.Entry entry : tempMap.entrySet()) {
            this.meshCaches.put((Item)entry.getKey(), new MeshRecipeCache((List)entry.getValue()));
        }
        this.recipeManager = null;
    }

    private static class MeshRecipeCache<T extends SieveRecipe> {
        private final Map<Item, List<T>> simpleRecipes = new HashMap<Item, List<T>>();

        private MeshRecipeCache(List<T> recipes) {
            HashMap<Item, ImmutableList.Builder> temp = new HashMap<Item, ImmutableList.Builder>();
            for (SieveRecipe sieveRecipe : recipes) {
                for (ItemStack item : sieveRecipe.ingredient.getItems()) {
                    temp.computeIfAbsent(item.getItem(), k -> ImmutableList.builder()).add((Object)sieveRecipe);
                }
            }
            for (Map.Entry entry : temp.entrySet()) {
                this.simpleRecipes.put((Item)entry.getKey(), (List<T>)((ImmutableList.Builder)entry.getValue()).build());
            }
        }

        public List<T> getRecipes(ItemStack input) {
            List<T> result = this.simpleRecipes.get(input.getItem());
            return result == null ? List.of() : result;
        }
    }
}

