/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crucible;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record CrucibleHeatRecipe(ResourceLocation id, BlockPredicate blockPredicate, int heatValue) implements Recipe<Container>
{
    public boolean matches(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.CRUCIBLE_HEAT_SOURCE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.CRUCIBLE_HEAT_SOURCE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleHeatRecipe> {
        public CrucibleHeatRecipe fromJson(ResourceLocation id, JsonObject json) {
            BlockPredicate blockPredicate = RecipeUtil.readBlockPredicate(id, json, "block_predicate");
            if (blockPredicate == null) {
                return null;
            }
            int heatValue = json.get("heat_value").getAsInt();
            return new CrucibleHeatRecipe(id, blockPredicate, heatValue);
        }

        public CrucibleHeatRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            BlockPredicate blockPredicate = RecipeUtil.readBlockPredicateNetwork(id, buffer);
            if (blockPredicate == null) {
                return null;
            }
            int heatValue = buffer.readVarInt();
            return new CrucibleHeatRecipe(id, blockPredicate, heatValue);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrucibleHeatRecipe recipe) {
            recipe.blockPredicate.toNetwork(buffer);
            buffer.writeVarInt(recipe.heatValue);
        }
    }
}

