/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crucible;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thedarkcolour.exdeorum.recipe.EFinishedRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;

public class FinishedCrucibleRecipe
extends EFinishedRecipe {
    private final RecipeSerializer<?> serializer;
    private final Ingredient ingredient;
    private final FluidStack fluidStack;

    public FinishedCrucibleRecipe(ResourceLocation id, RecipeSerializer<?> serializer, Ingredient ingredient, Fluid fluid, int amount) {
        this(id, serializer, ingredient, new FluidStack(fluid, amount));
    }

    public FinishedCrucibleRecipe(ResourceLocation id, RecipeSerializer<?> serializer, Ingredient ingredient, FluidStack fluidStack) {
        super(id);
        this.serializer = serializer;
        this.ingredient = ingredient;
        this.fluidStack = fluidStack;
    }

    public void serializeRecipeData(JsonObject json) {
        json.add("ingredient", this.ingredient.toJson());
        JsonObject fluidObj = new JsonObject();
        json.add("fluid", RecipeUtil.writeFluidStackJson(this.fluidStack));
    }

    public RecipeSerializer<?> getType() {
        return this.serializer;
    }
}

