/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.hammer;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.ProbabilityRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class HammerRecipe
extends ProbabilityRecipe {
    public HammerRecipe(ResourceLocation id, Ingredient ingredient, Item result, NumberProvider resultAmount, @Nullable CompoundTag resultNbt) {
        super(id, ingredient, result, resultAmount, resultNbt);
    }

    public static boolean areEqual(HammerRecipe a, HammerRecipe b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        return RecipeUtil.areIngredientsEqual(a.ingredient, b.ingredient) && Objects.equals(a.result, b.result) && Objects.equals(a.resultNbt, b.resultNbt);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.HAMMER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.HAMMER.get();
    }

    public static class Serializer
    extends AbstractSerializer<HammerRecipe> {
        @Override
        protected HammerRecipe createHammerRecipe(ResourceLocation id, Ingredient ingredient, Item result, NumberProvider resultAmount, @Nullable CompoundTag resultNbt) {
            return new HammerRecipe(id, ingredient, result, resultAmount, resultNbt);
        }
    }

    public static abstract class AbstractSerializer<T extends HammerRecipe>
    implements RecipeSerializer<T> {
        protected abstract T createHammerRecipe(ResourceLocation var1, Ingredient var2, Item var3, NumberProvider var4, @Nullable CompoundTag var5);

        public T fromJson(ResourceLocation name, JsonObject json) {
            Ingredient ingredient = RecipeUtil.readIngredient(json, "ingredient");
            Item result = RecipeUtil.readItem(json, "result");
            NumberProvider resultAmount = RecipeUtil.readNumberProvider(json, "result_amount");
            CompoundTag resultNbt = RecipeUtil.readNbtTag(json, "result_nbt");
            return this.createHammerRecipe(name, ingredient, result, resultAmount, resultNbt);
        }

        public T fromNetwork(ResourceLocation name, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            Item result = Objects.requireNonNull((Item)buffer.readById((IdMap)BuiltInRegistries.ITEM));
            NumberProvider resultAmount = RecipeUtil.fromNetworkNumberProvider(buffer);
            CompoundTag resultNbt = buffer.readNbt();
            return this.createHammerRecipe(name, ingredient, result, resultAmount, resultNbt);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((SingleIngredientRecipe)recipe).getIngredient().toNetwork(buffer);
            buffer.writeId((IdMap)BuiltInRegistries.ITEM, (Object)((HammerRecipe)recipe).result);
            RecipeUtil.toNetworkNumberProvider(buffer, ((HammerRecipe)recipe).resultAmount);
            buffer.writeNbt(((HammerRecipe)recipe).resultNbt);
        }
    }
}

