/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.blockentity.WaterCrucibleBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.FluidHelper;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.material.AbstractCrucibleMaterial;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EItems;

public abstract class AbstractCrucibleBlockEntity
extends ETankBlockEntity {
    public static final Lazy<HashMap<Item, Block>> MELT_OVERRIDES = Lazy.concurrentOf(() -> {
        HashMap<Item, Block> map = new HashMap<Item, Block>();
        AbstractCrucibleBlockEntity.addMeltOverrides(map);
        return map;
    });
    public static final int MAX_SOLIDS = 1000;
    public static final int MAX_FLUID_CAPACITY = 4000;
    private final ItemHandler item = new ItemHandler();
    private final FluidHandler tank = new FluidHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.item);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tank);
    @Nullable
    private Block lastMelted;
    @Nullable
    private Fluid fluid = null;
    private short solids;
    private boolean needsLightUpdate;
    public final boolean transparent;

    public AbstractCrucibleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.transparent = AbstractCrucibleMaterial.TRANSPARENT_CRUCIBLES.contains(state.m_60734_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.fluidHandler.cast();
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.itemHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        this.itemHandler.invalidate();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128359_("LastMelted", ForgeRegistries.BLOCKS.getKey((Object)this.lastMelted).toString());
        nbt.m_128359_("Fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
        nbt.m_128376_("Solids", this.solids);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt.m_128469_("Tank"));
        this.lastMelted = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("LastMelted")));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("Fluid")));
        this.solids = nbt.m_128448_("Solids");
        this.needsLightUpdate = true;
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257020_, (Object)this.tank.getFluid().getFluid());
        buffer.m_130130_(this.tank.getFluidAmount());
        buffer.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)(this.lastMelted != null ? this.lastMelted : Blocks.f_50016_));
        buffer.writeShort((int)this.solids);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        Fluid fluid = (Fluid)buffer.m_236816_((IdMap)BuiltInRegistries.f_257020_);
        if (fluid == null) {
            this.tank.setFluid(FluidStack.EMPTY);
            buffer.m_130242_();
        } else {
            this.tank.setFluid(new FluidStack(fluid, buffer.m_130242_()));
        }
        Block lastMelted = (Block)buffer.m_236816_((IdMap)BuiltInRegistries.f_256975_);
        this.lastMelted = lastMelted == Blocks.f_50016_ ? null : lastMelted;
        this.solids = buffer.readShort();
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            if (playerItem.m_41720_() == Items.f_42590_ && this.m_58903_() == EBlockEntities.WATER_CRUCIBLE.get() && ((Boolean)EConfig.SERVER.allowWaterBottleTransfer.get()).booleanValue()) {
                FluidStack fluid = new FluidStack((Fluid)Fluids.f_76193_, 250);
                if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                    BarrelBlockEntity.extractWaterBottle((IFluidHandler)this.tank, level, player, playerItem, fluid);
                    this.markUpdated();
                }
            } else if (this.canInsertItem(playerItem)) {
                this.tryMelt(playerItem, player.m_150110_().f_35937_ ? stack -> {} : stack -> stack.m_41774_(1));
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    protected abstract CrucibleRecipe getRecipe(ItemStack var1);

    private void tryMelt(ItemStack item, Consumer<ItemStack> shrinkAction) {
        HashMap melts;
        if (item.m_41619_()) {
            return;
        }
        Item meltItem = item.m_41720_();
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe == null) {
            this.item.setStackInSlot(0, ItemStack.f_41583_);
            return;
        }
        FluidStack result = recipe.getResult();
        FluidStack contained = this.tank.getFluid();
        shrinkAction.accept(item);
        this.solids = (short)Math.min(this.solids + result.getAmount(), 1000);
        if (contained.isEmpty()) {
            this.fluid = result.getFluid();
            this.needsLightUpdate = true;
        }
        if ((melts = (HashMap)MELT_OVERRIDES.get()).containsKey(meltItem)) {
            this.lastMelted = (Block)melts.get(meltItem);
        } else if (meltItem.getClass() == BlockItem.class) {
            this.lastMelted = ((BlockItem)meltItem).m_40614_();
        } else if (this.lastMelted == null) {
            this.lastMelted = this.getDefaultMeltBlock();
        }
        this.markUpdated();
    }

    private boolean canInsertItem(ItemStack item) {
        if (item.m_41619_()) {
            return false;
        }
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe != null) {
            FluidStack contained;
            FluidStack result = recipe.getResult();
            return (result.isFluidEqual(contained = this.tank.getFluid()) || contained.isEmpty()) && result.getAmount() + this.solids <= 1000;
        }
        return false;
    }

    public abstract int getMeltingRate();

    public int getSolids() {
        return this.solids;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public abstract Block getDefaultMeltBlock();

    @Nullable
    public Block getLastMelted() {
        return this.lastMelted;
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        this.fluidHandler.invalidate();
        super.m_7651_();
    }

    private static void addMeltOverrides(HashMap<Item, Block> overrides) {
        overrides.put(Items.f_42799_, Blocks.f_50050_);
        overrides.put(Items.f_42800_, Blocks.f_50051_);
        overrides.put(Items.f_41827_, Blocks.f_50054_);
        overrides.put(Items.f_41826_, Blocks.f_50053_);
        overrides.put(Items.f_41828_, Blocks.f_50055_);
        overrides.put(Items.f_42801_, Blocks.f_50052_);
        overrides.put(Items.f_271375_, Blocks.f_271115_);
        overrides.put(Items.f_220175_, Blocks.f_220838_);
        overrides.put(Items.f_42780_, Blocks.f_50051_);
        overrides.put(Items.f_151079_, Blocks.f_152544_);
        overrides.put((Item)EItems.GRASS_SEEDS.get(), Blocks.f_50440_);
        overrides.put((Item)EItems.MYCELIUM_SPORES.get(), Blocks.f_50195_);
        overrides.put((Item)EItems.WARPED_NYLIUM_SPORES.get(), Blocks.f_50690_);
        overrides.put((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), Blocks.f_50699_);
        for (Map.Entry sapling : ForgeRegistries.BLOCKS.getEntries()) {
            ResourceLocation key;
            Item item = ((Block)sapling.getValue()).m_5456_();
            if (overrides.containsKey(item) || !(key = ((ResourceKey)sapling.getKey()).m_135782_()).m_135815_().endsWith("sapling")) continue;
            try {
                overrides.put(item, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.m_135827_(), key.m_135815_().replace("sapling", "leaves"))));
            }
            catch (Exception exception) {}
        }
    }

    private class ItemHandler
    extends ItemStackHandler {
        private ItemHandler() {
        }

        protected void onContentsChanged(int slot) {
            AbstractCrucibleBlockEntity.this.tryMelt(this.getItem(), item -> this.setStackInSlot(0, ItemStack.f_41583_));
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AbstractCrucibleBlockEntity.this.canInsertItem(stack);
        }

        public ItemStack getItem() {
            return (ItemStack)this.stacks.get(0);
        }
    }

    private static class FluidHandler
    extends FluidHelper {
        public FluidHandler() {
            super(4000);
        }

        public boolean isFluidValid(FluidStack stack) {
            return false;
        }
    }

    public static class Ticker
    implements BlockEntityTicker<AbstractCrucibleBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, AbstractCrucibleBlockEntity crucible) {
            if (crucible.needsLightUpdate) {
                level.m_5518_().m_7174_(crucible.f_58858_);
                crucible.needsLightUpdate = false;
            }
            if (!level.f_46443_) {
                FluidHandler tank = crucible.tank;
                if (level.m_46467_() % 10L == 0L) {
                    short delta = (short)Math.min(crucible.solids, crucible.getMeltingRate());
                    if (delta <= 0) {
                        return;
                    }
                    if (tank.getSpace() >= delta) {
                        crucible.solids = (short)(crucible.solids - delta);
                        if (tank.isEmpty()) {
                            if (crucible.fluid != null) {
                                tank.setFluid(new FluidStack(crucible.fluid, (int)delta));
                                crucible.needsLightUpdate = true;
                            }
                        } else {
                            tank.getFluid().grow((int)delta);
                        }
                        crucible.markUpdated();
                    }
                }
                if (((Boolean)EConfig.SERVER.cruciblesCollectRainWater.get()).booleanValue() && tank.getFluidAmount() < 4000 && crucible instanceof WaterCrucibleBlockEntity && level.m_46758_(pos.m_7494_())) {
                    BarrelBlockEntity.fillRainWater(crucible, tank);
                }
            }
        }
    }
}

