/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.network.NetworkHooks;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.EnergyHelper;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;

public abstract class AbstractMachineBlockEntity<M extends AbstractMachineBlockEntity<M>>
extends EBlockEntity
implements MenuProvider {
    public final ItemHelper inventory;
    public final EnergyHelper energy;
    protected int redstoneMode;
    protected boolean hasRedstonePower;
    private final LazyOptional<ItemHelper> capabilityInventory;
    private final LazyOptional<EnergyStorage> capabilityEnergy;

    public AbstractMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Function<M, ItemHelper> inventory, int maxEnergy) {
        super(type, pos, state);
        this.inventory = inventory.apply((M)((Object)this));
        this.energy = new EnergyHelper(maxEnergy);
        this.capabilityInventory = LazyOptional.of(() -> this.inventory);
        this.capabilityEnergy = LazyOptional.of(() -> this.energy);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("energy", this.energy.getEnergyStored());
        nbt.m_128405_("redstoneMode", this.redstoneMode);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.energy.setStoredEnergy(nbt.m_128451_("energy"));
        this.redstoneMode = Mth.m_14045_((int)nbt.m_128451_("redstoneMode"), (int)0, (int)2);
    }

    public void onLoad() {
        this.checkPoweredState(this.f_58857_, this.f_58858_);
    }

    public void checkPoweredState(Level level, BlockPos pos) {
        this.hasRedstonePower = level.m_276867_(pos);
    }

    public void setRedstoneMode(int redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.capabilityEnergy.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capabilityInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capabilityEnergy.invalidate();
        this.capabilityInventory.invalidate();
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> {
                buffer.m_130064_(this.m_58899_());
                buffer.writeByte(this.redstoneMode);
            });
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    protected abstract boolean isRunning();

    protected abstract void tryStartRunning();

    protected abstract void runMachineTick();

    protected abstract int getEnergyConsumption();

    protected void noEnergyTick() {
    }

    public static class ServerTicker<M extends AbstractMachineBlockEntity<M>>
    implements BlockEntityTicker<M> {
        public void tick(Level level, BlockPos pos, BlockState state, M machine) {
            if (((AbstractMachineBlockEntity)((Object)machine)).redstoneMode == 0 || ((AbstractMachineBlockEntity)((Object)machine)).redstoneMode == 1 != ((AbstractMachineBlockEntity)((Object)machine)).hasRedstonePower) {
                int energyConsumption = ((AbstractMachineBlockEntity)((Object)machine)).getEnergyConsumption();
                if (((AbstractMachineBlockEntity)((Object)machine)).energy.getEnergyStored() >= energyConsumption) {
                    if (!((AbstractMachineBlockEntity)((Object)machine)).isRunning()) {
                        ((AbstractMachineBlockEntity)((Object)machine)).tryStartRunning();
                    }
                    if (((AbstractMachineBlockEntity)((Object)machine)).isRunning()) {
                        ((AbstractMachineBlockEntity)((Object)machine)).energy.extractEnergy(energyConsumption, false);
                        ((AbstractMachineBlockEntity)((Object)machine)).runMachineTick();
                    }
                } else {
                    ((AbstractMachineBlockEntity)((Object)machine)).noEnergyTick();
                }
            }
        }
    }
}

