/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.AbstractSieveBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.menu.MechanicalSieveMenu;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalSieveBlockEntity
extends AbstractMachineBlockEntity<MechanicalSieveBlockEntity>
implements SieveLogic.Owner {
    private static final Component TITLE = Component.m_237115_((String)"exdeorum.container.mechanical_sieve");
    private static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    private final SieveLogic logic = new SieveLogic(this, true);

    public MechanicalSieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), pos, state, ItemHandler::new, (Integer)EConfig.SERVER.mechanicalSieveEnergyStorage.get());
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.logic.saveNbt(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.logic.loadNbt(nbt);
    }

    @Override
    protected boolean isRunning() {
        return !this.logic.getContents().m_41619_();
    }

    @Override
    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (this.logic.isValidInput(input)) {
            this.logic.startSifting(AbstractSieveBlockEntity.singleCopy(input));
            input.m_41774_(1);
        }
    }

    @Override
    protected void runMachineTick() {
        this.logic.sift(0.01f, Long.MAX_VALUE);
    }

    @Override
    protected int getEnergyConsumption() {
        return (Integer)EConfig.SERVER.mechanicalSieveEnergyConsumption.get();
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.logic.getMesh());
        buffer.writeFloat(this.logic.getProgress());
        buffer.m_130055_(this.logic.getContents());
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        this.logic.setMesh(buffer.m_130267_(), false);
        this.logic.setProgress(buffer.readFloat());
        this.logic.setContents(buffer.m_130267_());
    }

    @Override
    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        ItemStack remainder = result.m_41777_();
        for (int i = 2; i < 22; ++i) {
            boolean splitRemainder;
            ItemStack existing = this.inventory.getStackInSlot(i);
            int limit = this.inventory.getSlotLimit(i);
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)remainder, (ItemStack)existing)) continue;
                limit -= existing.m_41613_();
            }
            if (limit <= 0) continue;
            boolean bl = splitRemainder = remainder.m_41613_() > limit;
            if (existing.m_41619_()) {
                this.inventory.setStackInSlot(i, splitRemainder ? ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)limit) : remainder);
            } else {
                existing.m_41769_(splitRemainder ? limit : remainder.m_41613_());
            }
            if (splitRemainder) {
                remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)(remainder.m_41613_() - limit));
                continue;
            }
            return true;
        }
        return remainder.m_41613_() < result.m_41613_();
    }

    public Component m_5446_() {
        return TITLE;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player pPlayer) {
        return new MechanicalSieveMenu(containerId, playerInventory, this);
    }

    @Override
    public SieveLogic getLogic() {
        return this.logic;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.f_58857_;
    }

    private static class ItemHandler
    extends ItemHelper {
        private final MechanicalSieveBlockEntity sieve;

        public ItemHandler(MechanicalSieveBlockEntity sieve) {
            super(22);
            this.sieve = sieve;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return !RecipeUtil.getSieveRecipes(this.getStackInSlot(1).m_41720_(), stack).isEmpty();
            }
            if (slot == 1) {
                return stack.m_204117_(EItemTags.SIEVE_MESHES);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        public boolean canMachineExtract(int slot) {
            return slot > 1;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1));
            }
        }

        protected void onLoad() {
            this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1), false);
        }
    }
}

