/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.compat.jei.ClientJeiUtil;
import thedarkcolour.exdeorum.compat.jei.CrookJeiRecipe;
import thedarkcolour.exdeorum.compat.jei.CycleTimer;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.registry.EItems;

class CrookCategory
implements IRecipeCategory<CrookJeiRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable slot;
    private final Component title;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private final CycleTimer timer = new CycleTimer(0);

    CrookCategory(IJeiHelpers helpers, IDrawable arrow) {
        IGuiHelper helper = helpers.getGuiHelper();
        this.background = helper.createBlankDrawable(120, 48);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)EItems.CROOK.get()));
        this.arrow = arrow;
        this.slot = helper.getSlotDrawable();
        this.title = Component.m_237115_((String)"gui.exdeorum.category.crook");
        this.focusFactory = helpers.getFocusFactory();
        this.ingredientManager = helpers.getIngredientManager();
    }

    public RecipeType<CrookJeiRecipe> getRecipeType() {
        return ExDeorumJeiPlugin.CROOK;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrookJeiRecipe recipe, IFocusGroup focuses) {
        recipe.addIngredients(builder);
        ItemStack result = new ItemStack((ItemLike)recipe.result, 1);
        result.m_41751_(recipe.getResultNbt());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 18).addItemStack(result)).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(XeiUtil.formatChance(recipe.chance)));
    }

    public void draw(CrookJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.timer.onDraw();
        this.arrow.draw(graphics, 50, 18);
        this.slot.draw(graphics, 79, 17);
        BlockState state = this.timer.getCycledItem(recipe.states);
        ClientXeiUtil.renderBlock(graphics, state, 28.0f, 18.0f, 10.0f, 20.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Component> getTooltipStrings(CrookJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (!(12.0 < mouseX)) return List.of();
        if (!(mouseX < 44.0)) return List.of();
        if (!(10.0 < mouseY)) return List.of();
        if (!(mouseY < 42.0)) return List.of();
        Block block = this.timer.getCycledItem(recipe.states).m_60734_();
        ArrayList<Component> extraDetails = new ArrayList<Component>();
        if (recipe instanceof CrookJeiRecipe.StatesRecipe) {
            CrookJeiRecipe.StatesRecipe statesRecipe = (CrookJeiRecipe.StatesRecipe)recipe;
            if (!statesRecipe.requirements.isEmpty()) {
                extraDetails.add(XeiUtil.REQUIRES_CERTAIN_STATE);
                extraDetails.addAll(statesRecipe.requirements);
                return XeiUtil.getBlockTooltip(extraDetails, block);
            }
        }
        if (!(recipe instanceof CrookJeiRecipe.TagRecipe)) return XeiUtil.getBlockTooltip(extraDetails, block);
        CrookJeiRecipe.TagRecipe tagRecipe = (CrookJeiRecipe.TagRecipe)recipe;
        extraDetails.add((Component)Component.m_237113_((String)("#" + tagRecipe.tag.f_203868_())).m_130940_(ChatFormatting.GRAY));
        return XeiUtil.getBlockTooltip(extraDetails, block);
    }

    public boolean handleInput(CrookJeiRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && (input.m_84873_() == 0 || input.m_84873_() == 1) && 12.0 < mouseX && mouseX < 44.0 && 10.0 < mouseY && mouseY < 42.0) {
            Block block = this.timer.getCycledItem(recipe.states).m_60734_();
            ClientJeiUtil.checkTypedIngredient(this.ingredientManager, VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)block.m_5456_()), ingredient -> {
                if (input.m_84873_() == 0) {
                    ClientJeiUtil.showRecipes(this.focusFactory, ingredient);
                } else if (input.m_84873_() == 1) {
                    ClientJeiUtil.showUsages(this.focusFactory, ingredient);
                }
            });
            return true;
        }
        return false;
    }
}

