/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class BarrelFluidMixingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public final Fluid baseFluid;
    public final int baseFluidAmount;
    public final Fluid additiveFluid;
    public final Item result;
    @Nullable
    protected final CompoundTag resultNbt;
    public final boolean consumesAdditive;

    public BarrelFluidMixingRecipe(ResourceLocation id, Fluid baseFluid, int baseFluidAmount, Fluid additiveFluid, Item result, @Nullable CompoundTag resultNbt, boolean consumesAdditive) {
        this.id = id;
        this.baseFluid = baseFluid;
        this.baseFluidAmount = baseFluidAmount;
        this.additiveFluid = additiveFluid;
        this.result = result;
        this.resultNbt = resultNbt;
        this.consumesAdditive = consumesAdditive;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)this.result);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_MIXING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ERecipeTypes.BARREL_FLUID_MIXING.get();
    }

    @Nullable
    public CompoundTag getResultNbt() {
        return this.resultNbt == null ? null : this.resultNbt.m_6426_();
    }

    public static class Serializer
    implements RecipeSerializer<BarrelFluidMixingRecipe> {
        public BarrelFluidMixingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Fluid baseFluid = RecipeUtil.readFluid(json, "base_fluid");
            int baseFluidAmount = GsonHelper.m_13927_((JsonObject)json, (String)"base_fluid_amount");
            Fluid additiveFluid = RecipeUtil.readFluid(json, "additive_fluid");
            Item result = RecipeUtil.readItem(json, "result");
            CompoundTag resultNbt = RecipeUtil.readNbtTag(json, "result_nbt");
            boolean consumesAdditive = GsonHelper.m_13912_((JsonObject)json, (String)"consumes_additive");
            return new BarrelFluidMixingRecipe(id, baseFluid, baseFluidAmount, additiveFluid, result, resultNbt, consumesAdditive);
        }

        public void toNetwork(FriendlyByteBuf buffer, BarrelFluidMixingRecipe recipe) {
            buffer.writeRegistryId(ForgeRegistries.FLUIDS, (Object)recipe.baseFluid);
            buffer.m_130130_(recipe.baseFluidAmount);
            buffer.writeRegistryId(ForgeRegistries.FLUIDS, (Object)recipe.additiveFluid);
            buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)recipe.result);
            buffer.m_130079_(recipe.resultNbt);
            buffer.writeBoolean(recipe.consumesAdditive);
        }

        @Nullable
        public BarrelFluidMixingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Fluid baseFluid = (Fluid)buffer.readRegistryId();
            int baseFluidAmount = buffer.m_130242_();
            Fluid additiveFluid = (Fluid)buffer.readRegistryId();
            Item result = (Item)buffer.readRegistryId();
            CompoundTag resultNbt = buffer.m_130260_();
            boolean consumesAdditive = buffer.readBoolean();
            return new BarrelFluidMixingRecipe(id, baseFluid, baseFluidAmount, additiveFluid, result, resultNbt, consumesAdditive);
        }
    }
}

