/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.barrel.FluidTransformationRecipe;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class FluidTransformationRecipeCache {
    private RecipeManager recipeManager;
    @Nullable
    private Map<BlockState, Map<Fluid, FluidTransformationRecipe>> recipes;

    public FluidTransformationRecipeCache(RecipeManager manager) {
        this.recipeManager = manager;
    }

    @Nullable
    public FluidTransformationRecipe getRecipe(Fluid baseFluid, BlockState catalystState) {
        Map<Fluid, FluidTransformationRecipe> recipesForBase;
        if (this.recipes == null) {
            this.buildRecipes();
        }
        if ((recipesForBase = this.recipes.get(catalystState)) != null) {
            return recipesForBase.get(baseFluid);
        }
        return null;
    }

    private void buildRecipes() {
        this.recipes = new HashMap<BlockState, Map<Fluid, FluidTransformationRecipe>>();
        for (FluidTransformationRecipe recipe : this.recipeManager.m_44054_((RecipeType)ERecipeTypes.BARREL_FLUID_TRANSFORMATION.get()).values()) {
            recipe.catalyst.possibleStates().forEach(state -> this.recipes.computeIfAbsent((BlockState)state, key -> new HashMap()).put(recipe.baseFluid, recipe));
        }
        HashMap<Map, Map> dedupe = new HashMap<Map, Map>();
        for (Map.Entry<BlockState, Map<Fluid, FluidTransformationRecipe>> entry : this.recipes.entrySet()) {
            entry.setValue(dedupe.computeIfAbsent(entry.getValue(), Map::copyOf));
        }
        this.recipes = Map.copyOf(this.recipes);
        this.recipeManager = null;
    }
}

