/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;

public class SingleIngredientRecipeCache<T extends SingleIngredientRecipe> {
    private final Supplier<RecipeType<T>> recipeType;
    private RecipeManager recipeManager;
    @Nullable
    private Map<Item, T> simpleRecipes;
    @Nullable
    private List<T> complexRecipes;
    @Nullable
    private Collection<T> allRecipes;
    private boolean trackAllRecipes;

    public SingleIngredientRecipeCache(RecipeManager recipeManager, Supplier<RecipeType<T>> recipeType) {
        this.recipeType = recipeType;
        this.recipeManager = recipeManager;
    }

    public SingleIngredientRecipeCache<T> trackAllRecipes() {
        this.trackAllRecipes = true;
        return this;
    }

    @Nullable
    public T getRecipe(Item item) {
        return this.getRecipe(new ItemStack((ItemLike)item));
    }

    @Nullable
    public T getRecipe(ItemStack item) {
        SingleIngredientRecipe recipe;
        if (this.simpleRecipes == null) {
            this.buildRecipes();
        }
        if ((recipe = (SingleIngredientRecipe)this.simpleRecipes.get(item.m_41720_())) == null && this.complexRecipes != null) {
            for (SingleIngredientRecipe complexRecipe : this.complexRecipes) {
                if (!complexRecipe.getIngredient().test(item)) continue;
                return (T)complexRecipe;
            }
            return null;
        }
        return (T)recipe;
    }

    public Collection<T> getAllRecipes() {
        if (this.simpleRecipes == null) {
            this.buildRecipes();
        }
        return this.allRecipes;
    }

    private void buildRecipes() {
        this.simpleRecipes = new HashMap<Item, T>();
        ImmutableList.Builder complexRecipes = ImmutableList.builder();
        Collection allRecipes = this.recipeManager.m_44054_(this.recipeType.get()).values();
        for (SingleIngredientRecipe recipe : allRecipes) {
            Ingredient ingredient = recipe.getIngredient();
            if (ingredient.isSimple()) {
                for (ItemStack item : ingredient.m_43908_()) {
                    this.simpleRecipes.put(item.m_41720_(), recipe);
                }
                continue;
            }
            complexRecipes.add((Object)recipe);
        }
        this.complexRecipes = complexRecipes.build();
        if (this.complexRecipes.isEmpty()) {
            this.complexRecipes = null;
        }
        if (this.trackAllRecipes) {
            this.allRecipes = allRecipes;
        }
        this.recipeManager = null;
    }
}

