/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crook;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record CrookRecipe(ResourceLocation id, BlockPredicate blockPredicate, Item result, @Nullable CompoundTag resultNbt, float chance) implements Recipe<Container>
{
    @Nullable
    public CompoundTag getResultNbt() {
        return this.resultNbt == null ? null : this.resultNbt.m_6426_();
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        ItemStack result = new ItemStack((ItemLike)this.result, 1);
        result.m_41751_(this.getResultNbt());
        return result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ERecipeSerializers.CROOK.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ERecipeTypes.CROOK.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrookRecipe> {
        public CrookRecipe fromJson(ResourceLocation id, JsonObject json) {
            BlockPredicate blockPredicate = Objects.requireNonNull(RecipeUtil.readBlockPredicate(id, json, "block_predicate"));
            Item result = RecipeUtil.readItem(json, "result");
            CompoundTag resultNbt = RecipeUtil.readNbtTag(json, "result_nbt");
            float chance = json.get("chance").getAsFloat();
            return new CrookRecipe(id, blockPredicate, result, resultNbt, chance);
        }

        public CrookRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            BlockPredicate blockPredicate = RecipeUtil.readBlockPredicateNetwork(id, buffer);
            if (blockPredicate == null) {
                return null;
            }
            Item result = Objects.requireNonNull((Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_));
            CompoundTag resultNbt = buffer.m_130260_();
            float chance = buffer.readFloat();
            return new CrookRecipe(id, blockPredicate, result, resultNbt, chance);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrookRecipe recipe) {
            recipe.blockPredicate.toNetwork(buffer);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)recipe.result);
            buffer.m_130079_(recipe.resultNbt);
            buffer.writeFloat(recipe.chance);
        }
    }
}

