/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.sieve;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.compat.PreferredOres;
import thedarkcolour.exdeorum.recipe.ProbabilityRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class SieveRecipe
extends ProbabilityRecipe {
    public final Item mesh;
    public final boolean byHandOnly;

    public SieveRecipe(ResourceLocation id, Ingredient ingredient, Item mesh, Item result, NumberProvider resultAmount, @Nullable CompoundTag resultNbt, boolean byHandOnly) {
        super(id, ingredient, result, resultAmount, resultNbt);
        this.mesh = mesh;
        this.byHandOnly = byHandOnly;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ERecipeSerializers.SIEVE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ERecipeTypes.SIEVE.get();
    }

    public static boolean areEqual(SieveRecipe a, SieveRecipe b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        return a.byHandOnly == b.byHandOnly && Objects.equals(a.mesh, b.mesh) && RecipeUtil.areIngredientsEqual(a.ingredient, b.ingredient) && Objects.equals(a.result, b.result) && Objects.equals(a.resultNbt, b.resultNbt);
    }

    public static class Serializer
    extends AbstractSerializer<SieveRecipe> {
        @Override
        protected SieveRecipe createSieveRecipe(ResourceLocation id, Ingredient ingredient, Item mesh, Item result, NumberProvider resultAmount, @Nullable CompoundTag resultNbt, boolean byHandOnly) {
            return new SieveRecipe(id, ingredient, mesh, result, resultAmount, resultNbt, byHandOnly);
        }
    }

    public static abstract class AbstractSerializer<T extends SieveRecipe>
    implements RecipeSerializer<T> {
        protected abstract T createSieveRecipe(ResourceLocation var1, Ingredient var2, Item var3, Item var4, NumberProvider var5, @Nullable CompoundTag var6, boolean var7);

        public T fromJson(ResourceLocation id, JsonObject json) {
            Item result;
            Ingredient ingredient = RecipeUtil.readIngredient(json, "ingredient");
            Item mesh = RecipeUtil.readItem(json, "mesh");
            if (json.has("result")) {
                result = RecipeUtil.readItem(json, "result");
            } else if (json.has("result_tag")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"result_tag")));
                result = PreferredOres.getPreferredOre((TagKey<Item>)tag);
                if (result == Items.f_41852_) {
                    ExDeorum.LOGGER.info("Skipped loading recipe {} as result_tag {} was empty", (Object)id, (Object)tag);
                    return null;
                }
            } else {
                throw new JsonSyntaxException("missing \"result\" item location or \"result_tag\" tag location");
            }
            NumberProvider resultAmount = RecipeUtil.readNumberProvider(json, "result_amount");
            CompoundTag resultNbt = RecipeUtil.readNbtTag(json, "result_nbt");
            boolean byHandOnly = json.has("by_hand_only") && json.get("by_hand_only").getAsBoolean();
            return this.createSieveRecipe(id, ingredient, mesh, result, resultAmount, resultNbt, byHandOnly);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Item mesh = Objects.requireNonNull((Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_));
            Item result = Objects.requireNonNull((Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_));
            NumberProvider resultAmount = RecipeUtil.fromNetworkNumberProvider(buffer);
            CompoundTag resultNbt = buffer.m_130260_();
            boolean byHandOnly = buffer.readBoolean();
            return this.createSieveRecipe(id, ingredient, mesh, result, resultAmount, resultNbt, byHandOnly);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((SingleIngredientRecipe)recipe).getIngredient().m_43923_(buffer);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)((SieveRecipe)recipe).mesh);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)((SieveRecipe)recipe).result);
            RecipeUtil.toNetworkNumberProvider(buffer, ((SieveRecipe)recipe).resultAmount);
            buffer.m_130079_(((SieveRecipe)recipe).resultNbt);
            buffer.writeBoolean(((SieveRecipe)recipe).byHandOnly);
        }
    }
}

