/*
 * Decompiled with CFR 0.152.
 */
package com.mars.deimos.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;

public class DeimosRecipeGenerator {
    public static List<JsonObject> RECIPES = new ArrayList<JsonObject>();

    public static void createItemConvertorJson(String input, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        json.addProperty("category", "misc");
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredients", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createShapelessRecipeJson(ArrayList<String> input, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        json.addProperty("category", "misc");
        JsonArray ingredientsArray = new JsonArray();
        for (String item : input) {
            JsonObject ingredients = new JsonObject();
            ingredients.addProperty(item.startsWith("#") ? "tag" : "item", new class_2960(item.replace("#", "")).toString());
            ingredientsArray.add((JsonElement)ingredients);
        }
        json.add("ingredients", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createShapedRecipeJson(ArrayList<String> inputs, ArrayList<String> pattern, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        ArrayList<String> keys = new ArrayList<String>();
        int keyCounter = 0;
        for (String row : pattern) {
            for (int i = 0; i < row.length(); ++i) {
                String potentialKey = String.valueOf(row.charAt(i));
                if (Objects.equals(potentialKey, " ") || keys.contains(potentialKey)) continue;
                JsonObject individualKey = new JsonObject();
                individualKey.addProperty(inputs.get(keyCounter).startsWith("#") ? "tag" : "item", new class_2960(inputs.get(keyCounter)).toString());
                keyList.add(potentialKey, (JsonElement)individualKey);
                keys.add(potentialKey);
                ++keyCounter;
            }
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createShapedRecipeJson(ArrayList<String> items, ArrayList<String> pattern, String output) {
        DeimosRecipeGenerator.createShapedRecipeJson(items, pattern, output, 1);
    }

    @Deprecated
    public static void createShapedRecipeJson(ArrayList<Character> keys, ArrayList<String> inputs, ArrayList<String> pattern, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(inputs.get(i).startsWith("#") ? "tag" : "item", new class_2960(inputs.get(i).replace("#", "")).toString());
            keyList.add(String.valueOf(keys.get(i)), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    @Deprecated
    public static void createShapedRecipeJson(ArrayList<Character> keys, ArrayList<String> items, ArrayList<String> type, ArrayList<String> pattern, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), new class_2960(items.get(i)).toString());
            keyList.add(String.valueOf(keys.get(i)), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createSmeltingJson(String input, String output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smelting");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createBlastingJson(String input, String output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:blasting");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createSmokingJson(String input, String output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smoking");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createCampfireCookingJson(String input, String output, int cookingTime) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:campfire_cooking");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    @Deprecated
    public static void createCampfireCookingJson(String input, String output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:campfire_cooking");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", new class_2960(input).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createStoneCuttingJson(String input, String output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:stonecutting");
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty(input.startsWith("#") ? "tag" : "item", new class_2960(input.replace("#", "")).toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", new class_2960(output).toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createItemConvertorJson(class_2960 input, class_2960 output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        json.addProperty("category", "misc");
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredients", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createShapelessRecipeJson(ArrayList<class_2960> input, ArrayList<String> type, class_2960 output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        json.addProperty("category", "misc");
        JsonArray ingredientsArray = new JsonArray();
        int i = 0;
        for (class_2960 item : input) {
            JsonObject ingredients = new JsonObject();
            ingredients.addProperty(type.get(i), item.toString());
            ingredientsArray.add((JsonElement)ingredients);
            ++i;
        }
        json.add("ingredients", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createShapedRecipeJson(ArrayList<Character> keys, ArrayList<class_2960> items, ArrayList<String> type, ArrayList<String> pattern, class_2960 output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add(String.valueOf(keys.get(i)), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createSmeltingJson(class_2960 input, class_2960 output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smelting");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createBlastingJson(class_2960 input, class_2960 output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:blasting");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createSmokingJson(class_2960 input, class_2960 output, int cookingTime, float experience) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smoking");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        json.addProperty("experience", (Number)Float.valueOf(experience));
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createCampfireCookingJson(class_2960 input, class_2960 output, int cookingTime) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:campfire_cooking");
        json.addProperty("category", "misc");
        json.addProperty("cookingtime", (Number)cookingTime);
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }

    public static void createStoneCuttingJson(class_2960 input, class_2960 output, int count) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:stonecutting");
        JsonObject ingredients = new JsonObject();
        ingredients.addProperty("item", input.toString());
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add((JsonElement)ingredients);
        json.add("ingredient", (JsonElement)ingredientsArray);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)count);
        json.add("result", (JsonElement)result);
        RECIPES.add(json);
    }
}

