/*
 * Decompiled with CFR 0.152.
 */
package me.imf4ll.sweetkombat.listeners;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.imf4ll.sweetkombat.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/imf4ll/sweetkombat/listeners/EventsListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;Lorg/bukkit/configuration/file/FileConfiguration;)V", "onEntityDamage", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "sweetkombat"})
public final class EventsListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final FileConfiguration config;

    public EventsListener(@NotNull JavaPlugin plugin, @NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(config, "config");
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler
    public final void onEntityDamage(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getBoolean("enable-sweep")) {
            return;
        }
        Entity entity = event.getDamager();
        Intrinsics.checkNotNullExpressionValue(entity, "getDamager(...)");
        Entity damager = entity;
        double damage = event.getDamage();
        if (damager instanceof Player) {
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
                event.setCancelled(true);
                event.setDamage(0.0);
            } else if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                event.setDamage(damage);
            }
        }
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getBoolean("enable-sweep")) {
            return;
        }
        Utils utils = new Utils();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        utils.setAttackSpeed(player, this.config.getDouble("attack-speed"));
    }

    @EventHandler
    public final void onRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getBoolean("enable-sweep")) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> EventsListener.onRespawn$lambda$0(event, this), 1L);
    }

    private static final void onRespawn$lambda$0(PlayerRespawnEvent $event, EventsListener this$0) {
        Utils utils = new Utils();
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        utils.setAttackSpeed(player, this$0.config.getDouble("attack-speed"));
    }
}

