/*
 * Decompiled with CFR 0.152.
 */
package io.reallmerry.rRPNames.api.events;

import org.bukkit.OfflinePlayer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RPNameChangeEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final OfflinePlayer player;
    private final String oldFirstName;
    private final String oldLastName;
    private String newFirstName;
    private String newLastName;
    private boolean isCancelled;

    public RPNameChangeEvent(@NotNull OfflinePlayer player, @Nullable String oldFirstName, @Nullable String oldLastName, @NotNull String newFirstName, @NotNull String newLastName) {
        this.player = player;
        this.oldFirstName = oldFirstName;
        this.oldLastName = oldLastName;
        this.newFirstName = newFirstName;
        this.newLastName = newLastName;
    }

    @NotNull
    public OfflinePlayer getPlayer() {
        return this.player;
    }

    @Nullable
    public String getOldFullName() {
        if (this.oldFirstName == null || this.oldLastName == null) {
            return null;
        }
        return this.oldFirstName + " " + this.oldLastName;
    }

    @NotNull
    public String getNewFullName() {
        return this.newFirstName + " " + this.newLastName;
    }

    @NotNull
    public String getNewFirstName() {
        return this.newFirstName;
    }

    public void setNewFirstName(@NotNull String newFirstName) {
        this.newFirstName = newFirstName;
    }

    @NotNull
    public String getNewLastName() {
        return this.newLastName;
    }

    public void setNewLastName(@NotNull String newLastName) {
        this.newLastName = newLastName;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

