/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.SlayerTask;
import me.unfear.Slayer.mobtypes.MobType;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerData {
    public static final Random RANDOM = new Random();
    private final UUID player;
    private int kills;
    private SlayerTask currentTask;
    private int points;
    private int tasksCompleted;
    private boolean hasSentMessage = false;
    private final HashMap<Integer, Integer> shopItemsPurchased;
    private final HashMap<Integer, Integer> entityKills;

    public PlayerData(UUID player, int kills, SlayerTask currentTask, int points, int tasksCompleted, HashMap<Integer, Integer> shopItemsPurchased, HashMap<Integer, Integer> entityKills) {
        this.player = player;
        this.kills = kills;
        this.currentTask = currentTask;
        this.points = points;
        this.tasksCompleted = tasksCompleted;
        this.shopItemsPurchased = shopItemsPurchased;
        this.entityKills = entityKills;
        for (MobType type : Main.inst.getMobTypeLoader().getMobTypes()) {
            this.entityKills.putIfAbsent(type.getId(), 0);
        }
    }

    public PlayerData(UUID player) {
        this(player, 0, null, 0, 0, new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>());
    }

    public HashMap<Integer, Integer> getEntityKills() {
        return this.entityKills;
    }

    public void incrementEntityKills(int id) {
        this.entityKills.putIfAbsent(id, 0);
        this.entityKills.put(id, this.entityKills.get(id) + 1);
    }

    public HashMap<Integer, Integer> getShopItemsPurchased() {
        return this.shopItemsPurchased;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
        if (this.getCurrentTask() == null || this.kills < this.getCurrentTask().getKills() || this.hasSentMessage) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)this.player);
        if (p == null) {
            return;
        }
        p.sendMessage(Main.inst.getLanguage().slayerComplete());
        this.hasSentMessage = true;
    }

    public SlayerTask getCurrentTask() {
        return this.currentTask;
    }

    public boolean completedCurrentTask() {
        return this.getCurrentTask() != null && this.getCurrentTask().getKills() <= this.kills;
    }

    public void setCurrentTask(SlayerTask currentTask) {
        this.currentTask = currentTask;
        this.setKills(0);
        this.hasSentMessage = false;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public int getTasksCompleted() {
        return this.tasksCompleted;
    }

    public void setTasksCompleted(int tasksCompleted) {
        this.tasksCompleted = tasksCompleted;
    }

    public UUID getPlayer() {
        return this.player;
    }

    private Integer getCurrentTaskId() {
        SlayerTask task = this.getCurrentTask();
        if (task == null) {
            return null;
        }
        return task.getId();
    }

    public int getReward() {
        if (this.currentTask == null) {
            return 0;
        }
        return this.currentTask.getReward();
    }

    public void save() {
        File file;
        if (Bukkit.getPlayer((UUID)this.player) == null) {
            this.hasSentMessage = false;
        }
        if ((file = new File(Main.inst.getDataFolder(), "data" + File.separator + String.valueOf(this.player) + ".yml")).exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("kills", (Object)this.kills);
        config.set("current-task", (Object)this.getCurrentTaskId());
        config.set("points", (Object)this.points);
        config.set("tasks-completed", (Object)this.tasksCompleted);
        for (Map.Entry<Integer, Integer> entry : this.shopItemsPurchased.entrySet()) {
            config.set("shop-items-purchased." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
        for (Map.Entry<Integer, Integer> entry : this.entityKills.entrySet()) {
            config.set("entity-kills." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void receiveTask(Player player) {
        this.kills = 0;
        ArrayList<SlayerTask> tasks = Main.inst.getSlayerLoader().getSlayerTasks();
        int i = -1;
        while (i == -1 || tasks.get(i) == this.currentTask && tasks.size() > 1) {
            i = RANDOM.nextInt(tasks.size());
        }
        SlayerTask task = tasks.get(i);
        this.setCurrentTask(task);
        player.sendMessage(Main.inst.getLanguage().slayerTask(task.getKills(), task.getMobType().getName()));
    }
}

