/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer;

import java.util.ArrayList;
import me.unfear.Slayer.Chat;
import me.unfear.Slayer.Main;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ShopItem
implements Comparable<ShopItem> {
    private final int id;
    private final String name;
    private final ArrayList<String> description;
    private final int cost;
    private final ArrayList<String> commands;
    private final Material material;
    private final int itemAmount;
    private final int purchases;

    public ShopItem(int id, String name, ArrayList<String> description, int cost, ArrayList<String> commands, Material material, int itemAmount, int purchases) {
        this.id = id;
        this.name = Chat.format(name);
        this.description = new ArrayList(description.size());
        for (String line : description) {
            this.description.add(Chat.format(line));
        }
        this.cost = cost;
        this.commands = commands;
        this.material = material;
        this.itemAmount = itemAmount;
        this.purchases = purchases;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getDescription() {
        return this.description;
    }

    public int getCost() {
        return this.cost;
    }

    public ArrayList<String> getCommands() {
        return this.commands;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getItemAmount() {
        return this.itemAmount;
    }

    public int getPurchases() {
        return this.purchases;
    }

    public ItemStack createItem() {
        ItemStack item = new ItemStack(this.material, this.itemAmount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.name);
            ArrayList<String> lore = new ArrayList<String>(this.description);
            lore.add("");
            lore.add(Main.inst.getLanguage().shopCost(this.cost));
            lore.add(Main.inst.getLanguage().clickToPurchase());
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(Main.inst.itemKey(), PersistentDataType.INTEGER, (Object)this.id);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public int compareTo(ShopItem o) {
        return this.id - o.id;
    }
}

