/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.ShopItem;
import me.unfear.Slayer.SlayerTask;
import me.unfear.Slayer.mobtypes.MobType;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SlayerLoader {
    private ArrayList<SlayerTask> slayerTasks;
    private HashSet<PlayerData> playerData;
    private boolean allowSpawners;
    private int saveTimer;
    private ArrayList<ShopItem> shopItems;
    private boolean actionBarEnabled;
    private boolean claimRewardOpensMainMenu;
    private String shopBackCommand;
    private String mainBackCommand;
    private String rewardBackCommand;
    private String monstersBackCommand;
    private boolean cancelTask;

    public SlayerLoader() {
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.slayerTasks = new ArrayList();
        FileConfiguration config = Main.inst.getConfig();
        try {
            config.load(new File(Main.inst.getDataFolder(), "config.yml"));
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.allowSpawners = config.getBoolean("allow-spawners");
        this.saveTimer = config.getInt("save-timer");
        this.actionBarEnabled = config.getBoolean("action-bar-enabled", false);
        this.claimRewardOpensMainMenu = config.getBoolean("claim-reward-opens-main-menu", false);
        this.shopBackCommand = config.getString("back-buttons.shop", "none");
        this.monstersBackCommand = config.getString("back-buttons.monsters", "none");
        this.rewardBackCommand = config.getString("back-buttons.reward", "none");
        this.mainBackCommand = config.getString("back-buttons.main", "none");
        this.cancelTask = config.getBoolean("cancel-task", true);
        ConfigurationSection tasksConfig = config.getConfigurationSection("tasks");
        if (tasksConfig == null) {
            Main.inst.getLogger().severe("Failed to load slayer tasks.");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return;
        }
        for (String idString : tasksConfig.getKeys(false)) {
            Integer id = null;
            try {
                id = Integer.parseInt(idString);
            }
            catch (NumberFormatException e) {
                Main.inst.getLogger().severe("Failed to load a slayer task, id isn't a number (id=" + idString + ")");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            String mobTypeString = tasksConfig.getString(id + ".mob-type");
            Integer kills = tasksConfig.getInt(id + ".kills");
            String name = tasksConfig.getString(id + ".name");
            ArrayList description = (ArrayList)tasksConfig.getStringList(id + ".description");
            Integer reward = tasksConfig.getInt(id + ".reward");
            if (mobTypeString == null || kills == null || name == null || description == null || reward == null) {
                Main.inst.getLogger().severe("Failed to load a slayer task, missing value (id=" + id + ")");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            try {
                Integer.parseInt(mobTypeString);
            }
            catch (NumberFormatException e) {
                Main.inst.getLogger().severe("Failed to load a slayer task, mob type isn't an integer (id=" + id + ", mob type: " + mobTypeString + ")");
                Main.inst.getLogger().severe("Just updated to v0.1.0? Take a look at this: https://github.com/unfear-underscore/Slayer/wiki/Updating-to-0.1.0");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            MobType mobType = Main.inst.getMobTypeLoader().getMobType(Integer.parseInt(mobTypeString));
            if (mobType == null) {
                Main.inst.getLogger().severe("Failed to load a slayer task, mob type not a mob (id=" + id + ", mob type id: " + mobTypeString + ")");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            if (kills < 1) {
                Main.inst.getLogger().severe("Failed to load a slayer task, kills required < 1 (id=" + id + ")");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            if (reward < 0) {
                Main.inst.getLogger().severe("Failed to load a slayer task, reward < 0 (id=" + id + ")");
                Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                return;
            }
            this.slayerTasks.add(new SlayerTask(id, mobType, kills, name, description, reward));
        }
        this.shopItems = new ArrayList();
        ConfigurationSection shopSection = config.getConfigurationSection("shop");
        if (shopSection != null) {
            for (Object key : shopSection.getKeys(false)) {
                Integer id = null;
                try {
                    id = Integer.parseInt((String)key);
                }
                catch (NumberFormatException e) {
                    Main.inst.getLogger().severe("Failed to load a shop item, id isn't a number (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                key = (String)key + ".";
                String name = shopSection.getString((String)key + "name");
                ArrayList description = (ArrayList)shopSection.getStringList((String)key + "description");
                Integer cost = shopSection.getInt((String)key + "cost");
                ArrayList commands = (ArrayList)shopSection.getStringList((String)key + "commands");
                String materialString = shopSection.getString((String)key + "material");
                Integer itemAmount = shopSection.getInt((String)key + "itemAmount");
                Integer purchases = shopSection.getInt((String)key + "purchases");
                if (name == null || description == null || cost == null || commands == null || materialString == null || itemAmount == null || purchases == null) {
                    Main.inst.getLogger().severe("Failed to load a shop item, missing value (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                Material material = Material.valueOf((String)materialString);
                if (material == null) {
                    Main.inst.getLogger().severe("Failed to load a shop item, material is an invalid item (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                if (itemAmount < 1 || itemAmount > 64) {
                    Main.inst.getLogger().severe("Failed to load a shop item, item amount must be between 1 and 64 (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                if (purchases != -1 && purchases < 1) {
                    Main.inst.getLogger().severe("Failed to load a shop item, purchases must be >0 or -1 (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                if (cost < 0) {
                    Main.inst.getLogger().severe("Failed to load a shop item, cost must be >= 0 (id=" + (String)key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                this.shopItems.add(new ShopItem(id, name, description, cost, commands, material, itemAmount, purchases));
            }
        }
        if (shopSection == null || this.shopItems.size() == 0) {
            Main.inst.getLogger().warning("No shop items found in config.yml, players will be unable to spend slayer points.");
        }
        if (this.playerData != null) {
            this.save();
        }
        this.playerData = new HashSet();
    }

    public boolean isClaimRewardOpensMainMenu() {
        return this.claimRewardOpensMainMenu;
    }

    public String getShopBackCommand(String player) {
        return this.shopBackCommand.replace("%player%", player);
    }

    public String getMainBackCommand(String player) {
        return this.mainBackCommand.replace("%player%", player);
    }

    public String getRewardBackCommand(String player) {
        return this.rewardBackCommand.replace("%player%", player);
    }

    public String getMonstersBackCommand(String player) {
        return this.monstersBackCommand.replace("%player%", player);
    }

    public ArrayList<SlayerTask> getSlayerTasks() {
        return this.slayerTasks;
    }

    public boolean isAllowSpawners() {
        return this.allowSpawners;
    }

    public boolean isActionBarEnabled() {
        return this.actionBarEnabled;
    }

    public boolean isCancelTask() {
        return this.cancelTask;
    }

    public PlayerData getPlayerData(UUID uuid) {
        for (PlayerData data : this.playerData) {
            if (!data.getPlayer().equals(uuid)) continue;
            return data;
        }
        File file = new File(Main.inst.getDataFolder(), "data" + File.separator + String.valueOf(uuid) + ".yml");
        if (file.exists()) {
            YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)file);
            Integer kills = dataConfig.getInt("kills");
            SlayerTask slayerTask = this.getSlayerTask(dataConfig.getInt("current-task"));
            if (!dataConfig.isSet("current-task")) {
                slayerTask = null;
            }
            Integer points = dataConfig.getInt("points");
            Integer tasksCompleted = dataConfig.getInt("tasks-completed");
            if (kills == null || points == null || tasksCompleted == null) {
                Main.inst.getLogger().severe("Failed to load player data, missing value (uuid=" + String.valueOf(uuid) + ")");
                return this.create(uuid);
            }
            HashMap<Integer, Integer> shopItemsPurchased = new HashMap<Integer, Integer>();
            if (dataConfig.isSet("shop-items-purchased")) {
                for (Object key : dataConfig.getConfigurationSection("shop-items-purchased").getKeys(false)) {
                    try {
                        int id = Integer.parseInt((String)key);
                        int amount = dataConfig.getInt("shop-items-purchased." + (String)key);
                        if (!dataConfig.isSet("shop-items-purchased." + (String)key)) {
                            amount = 0;
                        }
                        shopItemsPurchased.put(id, amount);
                    }
                    catch (NumberFormatException e) {
                        Main.inst.getLogger().severe("Failed to load player data, shop id is not a number (uuid=" + String.valueOf(uuid) + ", id=" + (String)key + ")");
                        return this.create(uuid);
                    }
                }
            }
            HashMap<Integer, Integer> entityKills = new HashMap<Integer, Integer>();
            if (dataConfig.isSet("entity-kills")) {
                for (String key : dataConfig.getConfigurationSection("entity-kills").getKeys(false)) {
                    try {
                        int id = Integer.parseInt(key);
                        int amount = dataConfig.getInt("entity-kills." + key);
                        if (!dataConfig.isSet("entity-kills." + key)) {
                            amount = 0;
                        }
                        entityKills.put(id, amount);
                    }
                    catch (NumberFormatException e) {
                        Main.inst.getLogger().severe("Failed to load player data, mob type id is not a number (uuid=" + String.valueOf(uuid) + ", id=" + key + ")");
                        return this.create(uuid);
                    }
                }
            }
            PlayerData data = new PlayerData(uuid, kills, slayerTask, points, tasksCompleted, shopItemsPurchased, entityKills);
            this.playerData.add(data);
            return data;
        }
        return this.create(uuid);
    }

    private SlayerTask getSlayerTask(Integer id) {
        if (id == null) {
            return null;
        }
        for (SlayerTask task : this.slayerTasks) {
            if (task.getId() != id.intValue()) continue;
            return task;
        }
        return null;
    }

    public int getSaveTimer() {
        return this.saveTimer;
    }

    private PlayerData create(UUID uuid) {
        PlayerData data = new PlayerData(uuid);
        this.playerData.add(data);
        return data;
    }

    public void save() {
        for (PlayerData data : this.playerData) {
            data.save();
        }
    }

    public ShopItem getShopItem(int id) {
        for (ShopItem shopItem : this.shopItems) {
            if (shopItem.getId() != id) continue;
            return shopItem;
        }
        return null;
    }

    public ArrayList<ShopItem> getShopItems() {
        return this.shopItems;
    }
}

