/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.gui.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.unfear.Slayer.inventoryframework.HumanEntityCache;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import me.unfear.Slayer.inventoryframework.exception.XMLLoadException;
import me.unfear.Slayer.inventoryframework.gui.InventoryComponent;
import me.unfear.Slayer.inventoryframework.gui.type.util.InventoryBased;
import me.unfear.Slayer.inventoryframework.gui.type.util.NamedGui;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DropperGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent contentsComponent = new InventoryComponent(3, 3);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);

    public DropperGui(@NotNull String title) {
        super(title);
    }

    public DropperGui(@NotNull TextHolder title) {
        super(title);
    }

    public DropperGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public DropperGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getContentsComponent().display(this.getInventory(), 0);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public DropperGui copy() {
        DropperGui gui = new DropperGui(this.getTitleHolder(), this.plugin);
        gui.contentsComponent = this.contentsComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 8) {
            this.getContentsComponent().click(this, event, rawSlot);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 9);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.DROPPER);
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getContentsComponent() {
        return this.contentsComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static DropperGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return DropperGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static DropperGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        DropperGui dropperGui = new DropperGui(element.getAttribute("title"), plugin);
        dropperGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return dropperGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "contents": {
                    component = dropperGui.getContentsComponent();
                    break;
                }
                case "player-inventory": {
                    component = dropperGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return dropperGui;
    }

    @Nullable
    @Contract(pure=true)
    public static DropperGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return DropperGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(DropperGui.class));
    }

    @NotNull
    public static DropperGui load(@NotNull Object instance, @NotNull Element element) {
        return DropperGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(DropperGui.class));
    }
}

