/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.gui.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.unfear.Slayer.inventoryframework.HumanEntityCache;
import me.unfear.Slayer.inventoryframework.abstraction.EnchantingTableInventory;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import me.unfear.Slayer.inventoryframework.exception.XMLLoadException;
import me.unfear.Slayer.inventoryframework.gui.InventoryComponent;
import me.unfear.Slayer.inventoryframework.gui.type.util.InventoryBased;
import me.unfear.Slayer.inventoryframework.gui.type.util.NamedGui;
import me.unfear.Slayer.inventoryframework.util.version.Version;
import me.unfear.Slayer.inventoryframework.util.version.VersionMatcher;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnchantingTableGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent inputComponent = new InventoryComponent(2, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);
    @NotNull
    private final EnchantingTableInventory enchantingTableInventory = VersionMatcher.newEnchantingTableInventory(Version.getVersion());

    public EnchantingTableGui(@NotNull String title) {
        super(title);
    }

    public EnchantingTableGui(@NotNull TextHolder title) {
        super(title);
    }

    public EnchantingTableGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public EnchantingTableGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (!(humanEntity instanceof Player)) {
            throw new IllegalArgumentException("Enchanting tables can only be opened by players");
        }
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getInputComponent().display(this.getInventory(), 0);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public EnchantingTableGui copy() {
        EnchantingTableGui gui = new EnchantingTableGui(this.getTitleHolder(), this.plugin);
        gui.inputComponent = this.inputComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 1) {
            this.getInputComponent().click(this, event, rawSlot);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 2);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.enchantingTableInventory.createInventory(this.getTitleHolder());
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getInputComponent() {
        return this.inputComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static EnchantingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return EnchantingTableGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static EnchantingTableGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        EnchantingTableGui enchantingTableGui = new EnchantingTableGui(element.getAttribute("title"), plugin);
        enchantingTableGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return enchantingTableGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "input": {
                    component = enchantingTableGui.getInputComponent();
                    break;
                }
                case "player-inventory": {
                    component = enchantingTableGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return enchantingTableGui;
    }

    @Nullable
    @Contract(pure=true)
    public static EnchantingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return EnchantingTableGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(EnchantingTableGui.class));
    }

    @NotNull
    public static EnchantingTableGui load(@NotNull Object instance, @NotNull Element element) {
        return EnchantingTableGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(EnchantingTableGui.class));
    }
}

