/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.gui.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.unfear.Slayer.inventoryframework.HumanEntityCache;
import me.unfear.Slayer.inventoryframework.abstraction.GrindstoneInventory;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import me.unfear.Slayer.inventoryframework.exception.XMLLoadException;
import me.unfear.Slayer.inventoryframework.gui.InventoryComponent;
import me.unfear.Slayer.inventoryframework.gui.type.util.InventoryBased;
import me.unfear.Slayer.inventoryframework.gui.type.util.NamedGui;
import me.unfear.Slayer.inventoryframework.util.version.Version;
import me.unfear.Slayer.inventoryframework.util.version.VersionMatcher;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GrindstoneGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent itemsComponent = new InventoryComponent(1, 2);
    @NotNull
    private InventoryComponent resultComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);
    @NotNull
    private final GrindstoneInventory grindstoneInventory = VersionMatcher.newGrindstoneInventory(Version.getVersion());

    public GrindstoneGui(@NotNull String title) {
        super(title);
    }

    public GrindstoneGui(@NotNull TextHolder title) {
        super(title);
    }

    public GrindstoneGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public GrindstoneGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (!(humanEntity instanceof Player)) {
            throw new IllegalArgumentException("Grindstones can only be opened by players");
        }
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getItemsComponent().display(this.getInventory(), 0);
        this.getResultComponent().display(this.getInventory(), 2);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public GrindstoneGui copy() {
        GrindstoneGui gui = new GrindstoneGui(this.getTitleHolder(), this.plugin);
        gui.itemsComponent = this.itemsComponent.copy();
        gui.resultComponent = this.resultComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 1) {
            this.getItemsComponent().click(this, event, rawSlot);
        } else if (rawSlot == 2) {
            this.getResultComponent().click(this, event, 0);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 3);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.grindstoneInventory.createInventory(this.getTitleHolder());
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getItemsComponent() {
        return this.itemsComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getResultComponent() {
        return this.resultComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static GrindstoneGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return GrindstoneGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static GrindstoneGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        GrindstoneGui grindstoneGui = new GrindstoneGui(element.getAttribute("title"), plugin);
        grindstoneGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return grindstoneGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "items": {
                    component = grindstoneGui.getItemsComponent();
                    break;
                }
                case "result": {
                    component = grindstoneGui.getResultComponent();
                    break;
                }
                case "player-inventory": {
                    component = grindstoneGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return grindstoneGui;
    }

    @Nullable
    @Contract(pure=true)
    public static GrindstoneGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return GrindstoneGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(GrindstoneGui.class));
    }

    @NotNull
    public static GrindstoneGui load(@NotNull Object instance, @NotNull Element element) {
        return GrindstoneGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(GrindstoneGui.class));
    }
}

