/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.nms.v1_16_1;

import java.lang.reflect.Field;
import java.util.List;
import me.unfear.Slayer.inventoryframework.abstraction.AnvilInventory;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import me.unfear.Slayer.inventoryframework.nms.v1_16_1.util.TextHolderUtil;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.ContainerAccess;
import net.minecraft.server.v1_16_R1.ContainerAnvil;
import net.minecraft.server.v1_16_R1.ContainerProperty;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.ICrafting;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.InventoryClickType;
import net.minecraft.server.v1_16_R1.InventoryLargeChest;
import net.minecraft.server.v1_16_R1.InventorySubcontainer;
import net.minecraft.server.v1_16_R1.ItemStack;
import net.minecraft.server.v1_16_R1.PlayerInventory;
import net.minecraft.server.v1_16_R1.Slot;
import net.minecraft.server.v1_16_R1.TileEntityContainer;
import net.minecraft.server.v1_16_R1.TileEntityTypes;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(final @NotNull TextHolder title) {
        final InventorySubcontainer inputSlots = new InventorySubcontainer(2);
        final InventorySubcontainer resultSlot = new InventorySubcontainer(1);
        return new CraftInventoryAnvil(null, (IInventory)inputSlots, (IInventory)resultSlot, null){

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.ANVIL;
            }

            public IInventory getInventory() {
                return new InventoryViewProvider(){

                    @NotNull
                    @Contract(pure=true)
                    public Container createContainer(int containerId, PlayerInventory inventory) {
                        return new ContainerAnvilImpl(containerId, inventory.player, inputSlots, resultSlot);
                    }

                    @NotNull
                    @Contract(pure=true)
                    public IChatBaseComponent getContainerName() {
                        return TextHolderUtil.toComponent(title);
                    }
                };
            }
        };
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        @NotNull
        private final InventorySubcontainer inputSlots;
        @NotNull
        private final InventorySubcontainer resultSlot;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field propertiesField;
        @NotNull
        private final Field listenersField;

        public ContainerAnvilImpl(@NotNull int containerId, @NotNull EntityHuman player, @NotNull InventorySubcontainer inputSlots, InventorySubcontainer resultSlot) {
            super(containerId, player.inventory, ContainerAccess.at((World)player.world, (BlockPosition)BlockPosition.ZERO));
            this.inputSlots = inputSlots;
            this.resultSlot = resultSlot;
            this.checkReachable = false;
            this.levelCost.set((int)AnvilInventoryImpl.this.cost);
            InventoryLargeChest compoundContainer = new InventoryLargeChest((IInventory)inputSlots, (IInventory)resultSlot);
            this.updateSlot(0, (IInventory)compoundContainer);
            this.updateSlot(1, (IInventory)compoundContainer);
            this.updateSlot(2, (IInventory)compoundContainer);
            try {
                this.propertiesField = Container.class.getDeclaredField("d");
                this.propertiesField.setAccessible(true);
                this.listenersField = Container.class.getDeclaredField("listeners");
                this.listenersField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException(exception);
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.containerAccess.getLocation(), (IInventory)this.inputSlots, (IInventory)this.resultSlot, (ContainerAnvil)this);
            this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player.getBukkitEntity(), (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void c() {
            if (this.levelCost.c()) {
                this.broadcastFullState();
            } else {
                for (int index = 0; index < this.slots.size(); ++index) {
                    if (ItemStack.matches((ItemStack)((ItemStack)this.items.get(index)), (ItemStack)((Slot)this.slots.get(index)).getItem())) continue;
                    this.broadcastFullState();
                    return;
                }
            }
        }

        public void a(@Nullable String name) {
            String string = name = name == null ? "" : name;
            if (!name.equals(AnvilInventoryImpl.this.observableText.get())) {
                AnvilInventoryImpl.this.observableText.set(name);
            }
            this.broadcastFullState();
        }

        public ItemStack a(int index, int dragData, @NotNull InventoryClickType clickType, @NotNull EntityHuman player) {
            ItemStack item = super.a(index, dragData, clickType, player);
            this.broadcastFullState();
            return item;
        }

        protected ItemStack a(@NotNull EntityHuman player, @NotNull ItemStack stack) {
            return stack;
        }

        public void a(@NotNull IInventory container) {
            this.c();
        }

        public void e() {
        }

        public void b(@NotNull EntityHuman nmsPlayer) {
        }

        protected void a(@NotNull EntityHuman player, @NotNull World world, @NotNull IInventory inventory) {
        }

        private void broadcastFullState() {
            List properties;
            try {
                properties = (List)this.propertiesField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            for (int index = 0; index < properties.size(); ++index) {
                ContainerProperty property = (ContainerProperty)properties.get(index);
                if (!property.c()) continue;
                try {
                    for (ICrafting listener : (List)this.listenersField.get((Object)this)) {
                        listener.setContainerData((Container)this, index, property.get());
                    }
                    continue;
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            if (this.player instanceof EntityPlayer) {
                ((EntityPlayer)this.player).updateInventory((Container)this);
            }
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends TileEntityContainer {
        protected InventoryViewProvider() {
            super(TileEntityTypes.FURNACE);
        }

        public void clear() {
        }

        public int getSize() {
            return 0;
        }

        public boolean isEmpty() {
            return false;
        }

        public ItemStack getItem(int index) {
            return null;
        }

        public ItemStack splitStack(int firstIndex, int secondIndex) {
            return null;
        }

        public ItemStack splitWithoutUpdate(int index) {
            return null;
        }

        public void setItem(int index, ItemStack itemStack) {
        }

        public int getMaxStackSize() {
            return 0;
        }

        public boolean a(EntityHuman entityHuman) {
            return false;
        }

        public List<ItemStack> getContents() {
            return null;
        }

        public void onOpen(CraftHumanEntity craftHumanEntity) {
        }

        public void onClose(CraftHumanEntity craftHumanEntity) {
        }

        public List<HumanEntity> getViewers() {
            return null;
        }

        public void setMaxStackSize(int index) {
        }
    }
}

