/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.menus;

import me.unfear.Slayer.Language;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.inventoryframework.gui.GuiItem;
import me.unfear.Slayer.inventoryframework.gui.type.ChestGui;
import me.unfear.Slayer.inventoryframework.pane.OutlinePane;
import me.unfear.Slayer.inventoryframework.pane.Pane;
import me.unfear.Slayer.inventoryframework.pane.StaticPane;
import me.unfear.Slayer.menus.SlayerMonstersMenu;
import me.unfear.Slayer.menus.SlayerShopMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SlayerMenu {
    private static final Language lang = Main.inst.getLanguage();

    public static ChestGui create(Player player, PlayerData data) {
        ItemStack backButton;
        ItemMeta backButtonMeta;
        ItemStack receiveTask;
        ItemMeta receiveTaskMeta;
        ItemStack current;
        ItemMeta currentMeta;
        ItemStack monsters;
        ItemMeta monstersMeta;
        ItemStack shop;
        ItemMeta shopMeta;
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta backgroundMeta = background.getItemMeta();
        if (backgroundMeta != null) {
            backgroundMeta.setDisplayName(String.valueOf(ChatColor.RED) + " ");
            background.setItemMeta(backgroundMeta);
        }
        String currentTask = data.getCurrentTask() == null ? "None" : data.getCurrentTask().getName();
        ItemStack profile = new ItemStack(Material.BIRCH_SIGN);
        ItemMeta profileMeta = profile.getItemMeta();
        if (profileMeta != null) {
            profileMeta.setDisplayName(lang.slayerProfileName());
            profileMeta.setLore(lang.profileLore(data.getTasksCompleted(), data.getPoints(), currentTask));
            profile.setItemMeta(profileMeta);
        }
        if ((shopMeta = (shop = new ItemStack(Material.GOLD_NUGGET)).getItemMeta()) != null) {
            shopMeta.setDisplayName(lang.shopName());
            shopMeta.setLore(lang.shopLore());
            shop.setItemMeta(shopMeta);
        }
        if ((monstersMeta = (monsters = new ItemStack(Material.ZOMBIE_HEAD)).getItemMeta()) != null) {
            monstersMeta.setDisplayName(lang.monstersName());
            monstersMeta.setLore(lang.monstersLore());
            monsters.setItemMeta(monstersMeta);
        }
        if ((currentMeta = (current = new ItemStack(Material.ROTTEN_FLESH)).getItemMeta()) != null) {
            currentMeta.setDisplayName(lang.currentTaskName());
            if (data.getCurrentTask() != null) {
                currentMeta.setLore(lang.currentTaskProgress(data.getCurrentTask().getName(), data.getCurrentTask().getDescription(), data.getKills(), data.getCurrentTask().getKills(), data.getCurrentTask().getMobType().getName()));
            }
            currentMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            current.setItemMeta(currentMeta);
            current.addUnsafeEnchantment(Enchantment.ARROW_DAMAGE, 1);
        }
        if ((receiveTaskMeta = (receiveTask = new ItemStack(Material.IRON_SWORD)).getItemMeta()) != null) {
            receiveTaskMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (data.getCurrentTask() != null) {
                receiveTaskMeta.setDisplayName(lang.cancelTaskName());
                receiveTaskMeta.setLore(lang.cancelTaskLore());
            } else {
                receiveTaskMeta.setDisplayName(lang.receiveTaskName());
                receiveTaskMeta.setLore(lang.receiveTaskLore());
            }
            receiveTask.setItemMeta(receiveTaskMeta);
        }
        if ((backButtonMeta = (backButton = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            backButtonMeta.setDisplayName(lang.guiBackName());
            backButtonMeta.setLore(lang.guiBackLore());
        }
        backButton.setItemMeta(backButtonMeta);
        ChestGui gui = new ChestGui(3, lang.guiTitle());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        OutlinePane backgroundPane = new OutlinePane(0, 0, 9, 3, Pane.Priority.LOWEST);
        backgroundPane.addItem(new GuiItem(background));
        backgroundPane.setRepeat(true);
        gui.addPane(backgroundPane);
        StaticPane main = new StaticPane(0, 0, 9, 3);
        String backButtonCommand = Main.inst.getSlayerLoader().getMainBackCommand(player.getName());
        if (!backButtonCommand.equalsIgnoreCase("none")) {
            main.addItem(new GuiItem(backButton, event -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), backButtonCommand)), 0, 2);
        }
        main.addItem(new GuiItem(profile), 4, 2);
        main.addItem(new GuiItem(shop, event -> SlayerShopMenu.create(player, data, 0).show(event.getWhoClicked())), 4, 1);
        main.addItem(new GuiItem(monsters, event -> SlayerMonstersMenu.create(player, data, 0).show(event.getWhoClicked())), 1, 2);
        if (data.getCurrentTask() == null || Main.inst.getSlayerLoader().isCancelTask()) {
            main.addItem(new GuiItem(receiveTask, event -> {
                event.getWhoClicked().closeInventory();
                if (data.getCurrentTask() != null) {
                    data.setCurrentTask(null);
                    event.getWhoClicked().sendMessage(Main.inst.getLanguage().taskCancelled());
                    return;
                }
                data.receiveTask((Player)event.getWhoClicked());
            }), 7, 1);
        }
        if (data.getCurrentTask() != null) {
            main.addItem(new GuiItem(current), 1, 1);
        }
        gui.addPane(main);
        return gui;
    }
}

