/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.menus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.unfear.Slayer.Language;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.inventoryframework.gui.GuiItem;
import me.unfear.Slayer.inventoryframework.gui.type.ChestGui;
import me.unfear.Slayer.inventoryframework.pane.OutlinePane;
import me.unfear.Slayer.inventoryframework.pane.PaginatedPane;
import me.unfear.Slayer.inventoryframework.pane.Pane;
import me.unfear.Slayer.inventoryframework.pane.StaticPane;
import me.unfear.Slayer.mobtypes.MobType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SlayerMonstersMenu {
    private static final Language lang = Main.inst.getLanguage();

    private static ArrayList<ItemStack> getMonsterItems(PlayerData data) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, Integer> entry : data.getEntityKills().entrySet()) {
            MobType mobType = Main.inst.getMobTypeLoader().getMobType(entry.getKey());
            ItemStack item = new ItemStack(mobType.getMaterial());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.setDisplayName(lang.monsterGuiMonsterName(mobType.getName()));
                meta.setLore(List.of(lang.monsterGuiMonsterLore(entry.getValue())));
                item.setItemMeta(meta);
            }
            items.add(item);
        }
        return items;
    }

    public static ChestGui create(Player player, PlayerData data, int page) {
        String backButtonCommand;
        ItemStack backButton;
        ItemMeta slayerMasterMeta;
        ItemStack nextArrow;
        ItemMeta nextArrowMeta;
        ItemStack prevArrow;
        ItemMeta prevArrowMeta;
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta backgroundMeta = background.getItemMeta();
        if (backgroundMeta != null) {
            backgroundMeta.setDisplayName(String.valueOf(ChatColor.RED) + " ");
            background.setItemMeta(backgroundMeta);
        }
        if ((prevArrowMeta = (prevArrow = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            prevArrowMeta.setDisplayName(lang.monstersGuiPrevPageName());
            prevArrow.setItemMeta(prevArrowMeta);
        }
        if ((nextArrowMeta = (nextArrow = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            nextArrowMeta.setDisplayName(lang.monstersGuiNextPageName());
            nextArrow.setItemMeta(nextArrowMeta);
        }
        if ((slayerMasterMeta = (backButton = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            slayerMasterMeta.setDisplayName(lang.monstersGuiBackName());
            slayerMasterMeta.setLore(lang.monstersGuiBackLore());
            backButton.setItemMeta(slayerMasterMeta);
        }
        ChestGui gui = new ChestGui(6, lang.monsterGuiTitle());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        PaginatedPane pages = new PaginatedPane(0, 0, 9, 5);
        pages.populateWithItemStacks(SlayerMonstersMenu.getMonsterItems(data));
        gui.addPane(pages);
        OutlinePane backgroundPane = new OutlinePane(0, 5, 9, 1);
        backgroundPane.addItem(new GuiItem(background));
        backgroundPane.setRepeat(true);
        backgroundPane.setPriority(Pane.Priority.LOWEST);
        gui.addPane(backgroundPane);
        pages.setPage(page);
        gui.update();
        StaticPane navigation = new StaticPane(0, 5, 9, 1);
        if (page > 0) {
            navigation.addItem(new GuiItem(prevArrow, event -> {
                if (pages.getPage() > 0) {
                    SlayerMonstersMenu.create(player, data, page - 1).show(event.getWhoClicked());
                }
            }), 0, 0);
        }
        if (pages.getPage() < pages.getPages() - 1) {
            navigation.addItem(new GuiItem(new ItemStack(nextArrow), event -> {
                if (pages.getPage() < pages.getPages() - 1) {
                    SlayerMonstersMenu.create(player, data, page + 1).show(event.getWhoClicked());
                }
            }), 8, 0);
        }
        if (!(backButtonCommand = Main.inst.getSlayerLoader().getMonstersBackCommand(player.getName())).equalsIgnoreCase("none")) {
            navigation.addItem(new GuiItem(backButton, event -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), backButtonCommand)), 0, 2);
        }
        gui.addPane(navigation);
        return gui;
    }
}

