/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.placeholderapi;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.SlayerTask;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class SlayerPlaceholderExpansion
extends PlaceholderExpansion {
    private final PluginDescriptionFile pluginDescriptionFile;

    public SlayerPlaceholderExpansion(PluginDescriptionFile pluginDescriptionFile) {
        this.pluginDescriptionFile = pluginDescriptionFile;
    }

    @NotNull
    public String getIdentifier() {
        return "slayer";
    }

    @NotNull
    public String getAuthor() {
        return this.pluginDescriptionFile.getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.pluginDescriptionFile.getVersion();
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (player == null) {
            return null;
        }
        params = params.toLowerCase();
        PlayerData data = Main.inst.getSlayerLoader().getPlayerData(player.getUniqueId());
        SlayerTask task = data.getCurrentTask();
        switch (params) {
            case "points": {
                return String.valueOf(data.getPoints());
            }
            case "tasks_completed": {
                return String.valueOf(data.getTasksCompleted());
            }
            case "kills": {
                return String.valueOf(data.getKills());
            }
            case "required_kills": {
                return task == null ? "N/A" : String.valueOf(task.getKills());
            }
            case "current_task_name": {
                return task == null ? "N/A" : task.getName();
            }
            case "current_task_entity": {
                return task == null ? "N/A" : task.getMobType().getName();
            }
        }
        return null;
    }
}

