/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer;

import java.util.Objects;
import me.unfear.Slayer.Language;
import me.unfear.Slayer.SlayerLoader;
import me.unfear.Slayer.commands.CancelTaskCommand;
import me.unfear.Slayer.commands.CollectRewardCommand;
import me.unfear.Slayer.commands.GivePointsCommand;
import me.unfear.Slayer.commands.ReloadSlayerCommand;
import me.unfear.Slayer.commands.SlayerBuyCommand;
import me.unfear.Slayer.commands.SlayerCommand;
import me.unfear.Slayer.commands.StartTaskCommand;
import me.unfear.Slayer.listeners.EntityDeathListener;
import me.unfear.Slayer.listeners.SpawnerSpawnListener;
import me.unfear.Slayer.mobtypes.MobTypeLoader;
import me.unfear.Slayer.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Main
extends JavaPlugin {
    public static Main inst;
    private MobTypeLoader mobTypeLoader;
    private SlayerLoader slayerLoader;
    private Language language;
    private final NamespacedKey itemKey = new NamespacedKey((Plugin)this, "slayer-shop-item-id");
    private final NamespacedKey entityKey = new NamespacedKey((Plugin)this, "slayer-from-spawner");

    public void onEnable() {
        inst = this;
        this.saveDefaultConfig();
        this.language = new Language();
        this.mobTypeLoader = new MobTypeLoader();
        this.slayerLoader = new SlayerLoader();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderHook().hook(this.getDescription(), this.getLogger());
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new EntityDeathListener(this.language, this.slayerLoader), (Plugin)this);
        pm.registerEvents((Listener)new SpawnerSpawnListener(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("slayer")).setExecutor((CommandExecutor)new SlayerCommand());
        Objects.requireNonNull(this.getCommand("canceltask")).setExecutor((CommandExecutor)new CancelTaskCommand());
        Objects.requireNonNull(this.getCommand("collectrewards")).setExecutor((CommandExecutor)new CollectRewardCommand());
        Objects.requireNonNull(this.getCommand("starttask")).setExecutor((CommandExecutor)new StartTaskCommand());
        Objects.requireNonNull(this.getCommand("slayerbuy")).setExecutor((CommandExecutor)new SlayerBuyCommand(this.language, this.slayerLoader));
        Objects.requireNonNull(this.getCommand("givepoints")).setExecutor((CommandExecutor)new GivePointsCommand(this.language, this.slayerLoader));
        Objects.requireNonNull(this.getCommand("reloadslayer")).setExecutor((CommandExecutor)new ReloadSlayerCommand(this.mobTypeLoader, this.language, this.slayerLoader));
        new BukkitRunnable(){

            public void run() {
                Main.this.slayerLoader.save();
            }
        }.runTaskTimer((Plugin)this, (long)this.slayerLoader.getSaveTimer() * 20L, (long)this.slayerLoader.getSaveTimer() * 20L);
    }

    public void onDisable() {
        if (this.slayerLoader != null) {
            this.slayerLoader.save();
        }
    }

    public MobTypeLoader getMobTypeLoader() {
        return this.mobTypeLoader;
    }

    public SlayerLoader getSlayerLoader() {
        return this.slayerLoader;
    }

    public Language getLanguage() {
        return this.language;
    }

    public NamespacedKey itemKey() {
        return this.itemKey;
    }

    public NamespacedKey entityKey() {
        return this.entityKey;
    }
}

