/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.commands;

import me.unfear.Slayer.Language;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.ShopItem;
import me.unfear.Slayer.SlayerLoader;
import me.unfear.Slayer.commands.PlayerArg;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SlayerBuyCommand
implements CommandExecutor {
    private final Language language;
    private final SlayerLoader slayerLoader;

    public SlayerBuyCommand(Language language, SlayerLoader slayerLoader) {
        this.language = language;
        this.slayerLoader = slayerLoader;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        int id;
        Player player = PlayerArg.get(sender, args, 1, "slayer.buy.others");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.language.shopUsage());
            return true;
        }
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.language.shopUsage());
            return true;
        }
        ShopItem shopItem = this.slayerLoader.getShopItem(id);
        if (shopItem == null) {
            sender.sendMessage(this.language.invalidShopItem());
            return true;
        }
        PlayerData data = Main.inst.getSlayerLoader().getPlayerData(player.getUniqueId());
        if (data.getShopItemsPurchased().getOrDefault(shopItem.getId(), 0) >= shopItem.getPurchases() && shopItem.getPurchases() != -1) {
            sender.sendMessage(this.language.shopOutOfStock());
            return true;
        }
        if (data.getPoints() < shopItem.getCost()) {
            sender.sendMessage(this.language.tooExpensive());
            return true;
        }
        data.setPoints(data.getPoints() - shopItem.getCost());
        data.getShopItemsPurchased().put(shopItem.getId(), data.getShopItemsPurchased().getOrDefault(shopItem.getId(), 0) + 1);
        for (String cmd : shopItem.getCommands()) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.replace("%player%", player.getName()));
        }
        sender.sendMessage(Main.inst.getLanguage().transactionComplete(shopItem.getCost()));
        return true;
    }
}

