/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.abstraction;

import java.util.function.Consumer;
import me.unfear.Slayer.inventoryframework.abstraction.util.ObservableValue;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AnvilInventory {
    @NotNull
    protected final @NotNull ObservableValue<@NotNull String> observableText = new ObservableValue<String>("");
    protected short cost;

    public void setCost(short cost) {
        if (cost < 0) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        this.cost = cost;
    }

    @NotNull
    public abstract Inventory createInventory(@NotNull TextHolder var1);

    @NotNull
    @Contract(pure=true)
    public String getRenameText() {
        String text = this.observableText.get();
        if (text == null) {
            throw new IllegalStateException("Rename text is null");
        }
        return text;
    }

    public void subscribeToNameInputChanges(@NotNull Consumer<? super String> onNameInputChanged) {
        this.observableText.subscribe(onNameInputChanged);
    }
}

