/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.font.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.unfear.Slayer.inventoryframework.font.CSVFont;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Font {
    @NotNull
    private static final Map<String, Font> FONT_BY_NAME = new HashMap<String, Font>();
    public static final Font BIRCH_PLANKS = new CSVFont(' ', "/fonts/birch-planks.csv");
    public static final Font BLACK = new CSVFont(' ', "/fonts/black.csv");
    public static final Font BLUE = new CSVFont(' ', "/fonts/blue.csv");
    public static final Font BROWN = new CSVFont(' ', "/fonts/brown.csv");
    public static final Font COBBLESTONE = new CSVFont(' ', "/fonts/cobblestone.csv");
    public static final Font CYAN = new CSVFont(' ', "/fonts/cyan.csv");
    public static final Font DIAMOND = new CSVFont(' ', "/fonts/diamond.csv");
    public static final Font DIRT = new CSVFont(' ', "/fonts/dirt.csv");
    public static final Font GOLD = new CSVFont(' ', "/fonts/gold.csv");
    public static final Font GRAY = new CSVFont(' ', "/fonts/gray.csv");
    public static final Font GREEN = new CSVFont(' ', "/fonts/green.csv");
    public static final Font JUNGLE_PLANKS = new CSVFont(' ', "/fonts/jungle-planks.csv");
    public static final Font LETTER_CUBE = new CSVFont(' ', "/fonts/letter-cube.csv");
    public static final Font LIGHT_BLUE = new CSVFont(' ', "/fonts/light-blue.csv");
    public static final Font LIGHT_GRAY = new CSVFont(' ', "/fonts/light-gray.csv");
    public static final Font LIME = new CSVFont(' ', "/fonts/lime.csv");
    public static final Font MAGENTA = new CSVFont(' ', "/fonts/magenta.csv");
    public static final Font MONITOR = new CSVFont(' ', "/fonts/monitor.csv");
    public static final Font OAK_LOG = new CSVFont(' ', "/fonts/oak-log.csv");
    public static final Font OAK_PLANKS = new CSVFont(' ', "/fonts/oak-planks.csv");
    public static final Font ORANGE = new CSVFont(' ', "/fonts/orange.csv");
    public static final Font PINK = new CSVFont(' ', "/fonts/pink.csv");
    public static final Font PLUSH = new CSVFont(' ', "/fonts/plush.csv");
    public static final Font PUMPKIN = new CSVFont('_', "/fonts/pumpkin.csv");
    public static final Font PURPLE = new CSVFont(' ', "/fonts/purple.csv");
    public static final Font QUARTZ = new CSVFont(' ', "/fonts/quartz.csv");
    public static final Font RAINBOW = new CSVFont(' ', "/fonts/rainbow.csv");
    public static final Font RED = new CSVFont(' ', "/fonts/red.csv");
    public static final Font SPRUCE_PLANKS = new CSVFont(' ', "/fonts/spruce-planks.csv");
    public static final Font STONE = new CSVFont(' ', "/fonts/stone.csv");
    public static final Font WATERMELON = new CSVFont(' ', "/fonts/watermelon.csv");
    public static final Font WHITE = new CSVFont(' ', "/fonts/white.csv");
    public static final Font YELLOW = new CSVFont(' ', "/fonts/yellow.csv");

    @NotNull
    @Contract(pure=true)
    public abstract ItemStack getDefaultItem();

    @Nullable
    @Contract(pure=true)
    public abstract ItemStack toItem(char var1);

    @Nullable
    @Contract(pure=true)
    public static Font fromName(@NotNull String name) {
        return FONT_BY_NAME.get(name.replace(' ', '_').toUpperCase(Locale.getDefault()));
    }

    @Contract(pure=true)
    public static void registerFont(@NotNull String name, @NotNull Font font) {
        FONT_BY_NAME.put(name.replace(' ', '_').toUpperCase(Locale.getDefault()), font);
    }

    static {
        FONT_BY_NAME.put("BIRCH_PLANKS", BIRCH_PLANKS);
        FONT_BY_NAME.put("BLACK", BLACK);
        FONT_BY_NAME.put("BLUE", BLUE);
        FONT_BY_NAME.put("BROWN", BROWN);
        FONT_BY_NAME.put("COBBLESTONE", COBBLESTONE);
        FONT_BY_NAME.put("CYAN", CYAN);
        FONT_BY_NAME.put("DIAMOND", DIAMOND);
        FONT_BY_NAME.put("DIRT", DIRT);
        FONT_BY_NAME.put("GOLD", GOLD);
        FONT_BY_NAME.put("GRAY", GRAY);
        FONT_BY_NAME.put("GREEN", GREEN);
        FONT_BY_NAME.put("JUNGLE_PLANKS", JUNGLE_PLANKS);
        FONT_BY_NAME.put("LETTER_CUBE", LETTER_CUBE);
        FONT_BY_NAME.put("LIGHT_BLUE", LIGHT_BLUE);
        FONT_BY_NAME.put("LIGHT_GRAY", LIGHT_GRAY);
        FONT_BY_NAME.put("LIME", LIME);
        FONT_BY_NAME.put("MAGENTA", MAGENTA);
        FONT_BY_NAME.put("MONITOR", MONITOR);
        FONT_BY_NAME.put("OAK_LOG", OAK_LOG);
        FONT_BY_NAME.put("OAK_PLANKS", OAK_PLANKS);
        FONT_BY_NAME.put("ORANGE", ORANGE);
        FONT_BY_NAME.put("PINK", PINK);
        FONT_BY_NAME.put("PLUSH", PLUSH);
        FONT_BY_NAME.put("PUMPKIN", PUMPKIN);
        FONT_BY_NAME.put("PURPLE", PURPLE);
        FONT_BY_NAME.put("QUARTZ", QUARTZ);
        FONT_BY_NAME.put("RAINBOW", RAINBOW);
        FONT_BY_NAME.put("RED", RED);
        FONT_BY_NAME.put("SPRUCE_PLANKS", SPRUCE_PLANKS);
        FONT_BY_NAME.put("STONE", STONE);
        FONT_BY_NAME.put("WATERMELON", WATERMELON);
        FONT_BY_NAME.put("WHITE", WHITE);
        FONT_BY_NAME.put("YELLOW", YELLOW);
    }
}

