/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.unfear.Slayer.inventoryframework.gui.GuiItem;
import me.unfear.Slayer.inventoryframework.gui.type.util.Gui;
import me.unfear.Slayer.inventoryframework.pane.Pane;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InventoryComponent {
    @NotNull
    protected final List<Pane> panes = new ArrayList<Pane>();
    @Nullable
    private final ItemStack[][] items;
    private final int length;
    private final int height;

    public InventoryComponent(int length, int height) {
        if (length < 0 || height < 0) {
            throw new IllegalArgumentException("Sizes must be greater or equal to zero");
        }
        this.length = length;
        this.height = height;
        this.items = new ItemStack[length][height];
    }

    public void addPane(@NotNull Pane pane) {
        int size = this.getPanes().size();
        if (size == 0) {
            this.getPanes().add(pane);
            return;
        }
        Pane.Priority priority = pane.getPriority();
        int left = 0;
        int right = size - 1;
        while (left <= right) {
            int middle = (left + right) / 2;
            Pane.Priority middlePriority = this.getPane(middle).getPriority();
            if (middlePriority == priority) {
                this.getPanes().add(middle, pane);
                return;
            }
            if (middlePriority.isLessThan(priority)) {
                left = middle + 1;
                continue;
            }
            if (!middlePriority.isGreaterThan(priority)) continue;
            right = middle - 1;
        }
        this.getPanes().add(right + 1, pane);
    }

    public void display(@NotNull Inventory inventory, int offset) {
        this.display();
        this.placeItems(inventory, offset);
    }

    public void display(@NotNull PlayerInventory inventory, int offset) {
        this.display();
        this.placeItems(inventory, offset);
    }

    public void placeItems(@NotNull PlayerInventory inventory, int offset) {
        for (int x = 0; x < this.getLength(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int slot = y == this.getHeight() - 1 ? x + offset : (y + 1) * this.getLength() + x + offset;
                inventory.setItem(slot, this.getItem(x, y));
            }
        }
    }

    public void placeItems(@NotNull Inventory inventory, int offset) {
        for (int x = 0; x < this.getLength(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                inventory.setItem(y * this.getLength() + x + offset, this.getItem(x, y));
            }
        }
    }

    public void click(@NotNull Gui gui, @NotNull InventoryClickEvent event, int slot) {
        ArrayList<Pane> panes = new ArrayList<Pane>(this.getPanes());
        for (int i = panes.size() - 1; i >= 0 && !((Pane)panes.get(i)).click(gui, this, event, slot, 0, 0, this.getLength(), this.getHeight()); --i) {
        }
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent copy() {
        InventoryComponent inventoryComponent = new InventoryComponent(this.getLength(), this.getHeight());
        for (int x = 0; x < this.getLength(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                ItemStack item = this.getItem(x, y);
                if (item == null) continue;
                inventoryComponent.setItem(item.clone(), x, y);
            }
        }
        for (Pane pane : this.getPanes()) {
            inventoryComponent.addPane(pane.copy());
        }
        return inventoryComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent excludeRows(int from, int end) {
        if (from < 0 || end >= this.getHeight()) {
            throw new IllegalArgumentException("Specified range includes non-existent rows");
        }
        int newHeight = this.getHeight() - (end - from + 1);
        InventoryComponent newInventoryComponent = new InventoryComponent(this.getLength(), newHeight);
        for (Pane pane : this.getPanes()) {
            newInventoryComponent.addPane(pane);
        }
        for (int x = 0; x < this.getLength(); ++x) {
            int newY = 0;
            for (int y = 0; y < this.getHeight(); ++y) {
                ItemStack item = this.getItem(x, y);
                if (y >= from && y <= end) continue;
                if (item != null) {
                    newInventoryComponent.setItem(item, x, newY);
                }
                ++newY;
            }
        }
        return newInventoryComponent;
    }

    @Deprecated
    public void load(@NotNull Object instance, @NotNull Element element) {
        this.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(InventoryComponent.class));
    }

    public void load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        NodeList childNodes = element.getChildNodes();
        for (int innerIndex = 0; innerIndex < childNodes.getLength(); ++innerIndex) {
            Node innerItem = childNodes.item(innerIndex);
            if (innerItem.getNodeType() != 1) continue;
            this.addPane(Gui.loadPane(instance, innerItem, plugin));
        }
    }

    @Contract(pure=true)
    public boolean hasItem() {
        for (int x = 0; x < this.getLength(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.getItem(x, y) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void display() {
        this.clearItems();
        for (Pane pane : this.getPanes()) {
            if (!pane.isVisible()) continue;
            pane.display(this, 0, 0, this.getLength(), this.getHeight());
        }
    }

    @Contract(pure=true)
    public boolean hasItem(int x, int y) {
        return this.getItem(x, y) != null;
    }

    @Nullable
    @Contract(pure=true)
    public ItemStack getItem(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new IllegalArgumentException("Coordinates must be in-bounds: x = " + x + ", y = " + y + "; should be below " + this.getLength() + " and " + this.getHeight());
        }
        return this.items[x][y];
    }

    @NotNull
    @Contract(pure=true)
    public List<Pane> getPanes() {
        return this.panes;
    }

    public void setItem(@NotNull GuiItem guiItem, int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new IllegalArgumentException("Coordinates must be in-bounds: x = " + x + ", y = " + y + "; should be below " + this.getLength() + " and " + this.getHeight());
        }
        GuiItem copy = guiItem.copy();
        copy.applyUUID();
        this.items[x][y] = copy.getItem();
    }

    @Deprecated
    public void setItem(@NotNull ItemStack item, int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new IllegalArgumentException("Coordinates must be in-bounds: x = " + x + ", y = " + y + "; should be below " + this.getLength() + " and " + this.getHeight());
        }
        this.items[x][y] = item;
    }

    @Contract(pure=true)
    public int getSize() {
        return this.getLength() * this.getHeight();
    }

    @Contract(pure=true)
    public int getHeight() {
        return this.height;
    }

    @Contract(pure=true)
    public int getLength() {
        return this.length;
    }

    private void clearItems() {
        for (Object[] objectArray : this.items) {
            Arrays.fill(objectArray, null);
        }
    }

    @Contract(pure=true)
    private boolean isInBounds(int x, int y) {
        boolean xBounds = this.isInBounds(0, this.getLength() - 1, x);
        boolean yBounds = this.isInBounds(0, this.getHeight() - 1, y);
        return xBounds && yBounds;
    }

    @NotNull
    @Contract(pure=true)
    private Pane getPane(int index) {
        if (!this.isInBounds(0, this.panes.size() - 1, index)) {
            throw new IllegalArgumentException("Index not in pane list");
        }
        return this.panes.get(index);
    }

    @Contract(pure=true)
    private boolean isInBounds(int lowerBound, int upperBound, int value) {
        return lowerBound <= value && value <= upperBound;
    }
}

