/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.inventoryframework.gui.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.unfear.Slayer.inventoryframework.HumanEntityCache;
import me.unfear.Slayer.inventoryframework.abstraction.SmithingTableInventory;
import me.unfear.Slayer.inventoryframework.adventuresupport.TextHolder;
import me.unfear.Slayer.inventoryframework.exception.XMLLoadException;
import me.unfear.Slayer.inventoryframework.gui.InventoryComponent;
import me.unfear.Slayer.inventoryframework.gui.type.util.InventoryBased;
import me.unfear.Slayer.inventoryframework.gui.type.util.NamedGui;
import me.unfear.Slayer.inventoryframework.util.version.Version;
import me.unfear.Slayer.inventoryframework.util.version.VersionMatcher;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModernSmithingTableGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent inputComponent = new InventoryComponent(3, 1);
    @NotNull
    private InventoryComponent resultComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);
    @NotNull
    private final SmithingTableInventory smithingTableInventory = VersionMatcher.newModernSmithingTableInventory(Version.getVersion());

    public ModernSmithingTableGui(@NotNull String title) {
        super(title);
    }

    public ModernSmithingTableGui(@NotNull TextHolder title) {
        super(title);
    }

    public ModernSmithingTableGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public ModernSmithingTableGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void update() {
        this.updating = true;
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getInputComponent().display(this.getInventory(), 0);
        this.getResultComponent().display(this.getInventory(), 3);
        this.getPlayerInventoryComponent().display();
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.populateBottomInventory(viewer);
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.inventory == null) {
            this.update();
        }
        this.populateBottomInventory(humanEntity);
        humanEntity.openInventory(this.getInventory());
    }

    private void populateBottomInventory(@NotNull HumanEntity humanEntity) {
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ModernSmithingTableGui copy() {
        ModernSmithingTableGui gui = new ModernSmithingTableGui(this.getTitleHolder(), this.plugin);
        gui.inputComponent = this.inputComponent.copy();
        gui.resultComponent = this.resultComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 2) {
            this.getInputComponent().click(this, event, rawSlot);
        } else if (rawSlot == 3) {
            this.getResultComponent().click(this, event, 0);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 4);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.smithingTableInventory.createInventory(this.getTitleHolder());
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getInputComponent() {
        return this.inputComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getResultComponent() {
        return this.resultComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static ModernSmithingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return ModernSmithingTableGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static ModernSmithingTableGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        ModernSmithingTableGui smithingTableGui = new ModernSmithingTableGui(element.getAttribute("title"), plugin);
        smithingTableGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return smithingTableGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "input": {
                    component = smithingTableGui.getInputComponent();
                    break;
                }
                case "result": {
                    component = smithingTableGui.getResultComponent();
                    break;
                }
                case "player-inventory": {
                    component = smithingTableGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return smithingTableGui;
    }

    @Nullable
    @Contract(pure=true)
    public static ModernSmithingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return ModernSmithingTableGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(ModernSmithingTableGui.class));
    }

    @NotNull
    public static ModernSmithingTableGui load(@NotNull Object instance, @NotNull Element element) {
        return ModernSmithingTableGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(ModernSmithingTableGui.class));
    }
}

