/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.menus;

import me.unfear.Slayer.Language;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.inventoryframework.gui.GuiItem;
import me.unfear.Slayer.inventoryframework.gui.type.ChestGui;
import me.unfear.Slayer.inventoryframework.pane.OutlinePane;
import me.unfear.Slayer.inventoryframework.pane.Pane;
import me.unfear.Slayer.inventoryframework.pane.StaticPane;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SlayerRewardMenu {
    private static final Language lang = Main.inst.getLanguage();

    public static ChestGui create(Player player, PlayerData data) {
        ItemStack backButton;
        ItemMeta backButtonMeta;
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta backgroundMeta = background.getItemMeta();
        if (backgroundMeta != null) {
            backgroundMeta.setDisplayName(String.valueOf(ChatColor.RED) + " ");
            background.setItemMeta(backgroundMeta);
        }
        if ((backButtonMeta = (backButton = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            backButtonMeta.setDisplayName(lang.rewardGuiBackName());
            backButtonMeta.setLore(lang.rewardGuiBackLore());
        }
        backButton.setItemMeta(backButtonMeta);
        ItemStack reward = new ItemStack(Material.GOLD_BLOCK);
        ItemMeta rewardMeta = background.getItemMeta();
        rewardMeta.setDisplayName(lang.rewardGuiRewardName());
        rewardMeta.setLore(lang.rewardGuiRewardLore(data.getReward()));
        reward.setItemMeta(rewardMeta);
        ChestGui gui = new ChestGui(3, lang.rewardGuiTitle());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        OutlinePane backgroundPane = new OutlinePane(0, 0, 9, 3, Pane.Priority.LOWEST);
        backgroundPane.addItem(new GuiItem(background));
        backgroundPane.setRepeat(true);
        gui.addPane(backgroundPane);
        StaticPane backPane = new StaticPane(0, 0, 9, 3);
        String backButtonCommand = Main.inst.getSlayerLoader().getRewardBackCommand(player.getName());
        if (!backButtonCommand.equalsIgnoreCase("none")) {
            backPane.addItem(new GuiItem(backButton, event -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), backButtonCommand)), 0, 2);
        }
        gui.addPane(backPane);
        StaticPane rewardPane = new StaticPane(4, 1, 1, 1);
        rewardPane.addItem(new GuiItem(reward, event -> {
            event.getWhoClicked().closeInventory();
            event.getWhoClicked().sendMessage(Main.inst.getLanguage().rewardClaimed());
            data.setTasksCompleted(data.getTasksCompleted() + 1);
            data.setPoints(data.getPoints() + data.getReward());
            data.setCurrentTask(null);
            if (Main.inst.getSlayerLoader().isClaimRewardOpensMainMenu()) {
                Bukkit.getScheduler().runTaskLater((Plugin)Main.inst, () -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "slayer " + player.getName() + " -s"), 1L);
            }
        }), 0, 0);
        gui.addPane(rewardPane);
        return gui;
    }
}

