/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.menus;

import java.util.ArrayList;
import java.util.List;
import me.unfear.Slayer.Language;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.PlayerData;
import me.unfear.Slayer.ShopItem;
import me.unfear.Slayer.inventoryframework.gui.GuiItem;
import me.unfear.Slayer.inventoryframework.gui.type.ChestGui;
import me.unfear.Slayer.inventoryframework.pane.OutlinePane;
import me.unfear.Slayer.inventoryframework.pane.PaginatedPane;
import me.unfear.Slayer.inventoryframework.pane.Pane;
import me.unfear.Slayer.inventoryframework.pane.StaticPane;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class SlayerShopMenu {
    private static final Language lang = Main.inst.getLanguage();

    private static ArrayList<ItemStack> getShopItems(PlayerData data) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ShopItem shopItem : Main.inst.getSlayerLoader().getShopItems()) {
            if (!data.getShopItemsPurchased().containsKey(shopItem.getId())) {
                data.getShopItemsPurchased().put(shopItem.getId(), 0);
            }
            if (data.getShopItemsPurchased().getOrDefault(shopItem.getId(), 0) >= shopItem.getPurchases() && shopItem.getPurchases() != -1) continue;
            ItemStack item = shopItem.createItem();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List<String> lore;
                List list = lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
                if (shopItem.getCost() > data.getPoints()) {
                    if (!lore.isEmpty()) {
                        lore.remove(lore.size() - 1);
                    }
                    lore.add(Main.inst.getLanguage().tooExpensive());
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            items.add(item);
        }
        return items;
    }

    public static ChestGui create(Player player, PlayerData data, int page) {
        String backButtonCommand;
        ItemStack backButton;
        ItemMeta backButtonMeta;
        ItemStack points;
        ItemMeta pointsMeta;
        ItemStack nextArrow;
        ItemMeta nextArrowMeta;
        ItemStack prevArrow;
        ItemMeta prevArrowMeta;
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta backgroundMeta = background.getItemMeta();
        if (backgroundMeta != null) {
            backgroundMeta.setDisplayName(String.valueOf(ChatColor.RED) + " ");
            background.setItemMeta(backgroundMeta);
        }
        if ((prevArrowMeta = (prevArrow = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            prevArrowMeta.setDisplayName(Main.inst.getLanguage().previousPage());
            prevArrow.setItemMeta(prevArrowMeta);
        }
        if ((nextArrowMeta = (nextArrow = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            nextArrowMeta.setDisplayName(Main.inst.getLanguage().nextPage());
            nextArrow.setItemMeta(nextArrowMeta);
        }
        if ((pointsMeta = (points = new ItemStack(Material.GOLD_NUGGET)).getItemMeta()) != null) {
            pointsMeta.setDisplayName(lang.slayerPoints(data.getPoints()));
            points.setItemMeta(pointsMeta);
        }
        if ((backButtonMeta = (backButton = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            backButtonMeta.setDisplayName(lang.shopGuiBackName());
            backButtonMeta.setLore(lang.shopGuiBackLore());
        }
        backButton.setItemMeta(backButtonMeta);
        ChestGui gui = new ChestGui(6, Main.inst.getLanguage().shopGuiTitle());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        PaginatedPane pages = new PaginatedPane(0, 0, 9, 5);
        pages.populateWithItemStacks(SlayerShopMenu.getShopItems(data));
        pages.setOnClick(event -> {
            ItemStack currentItem = event.getCurrentItem();
            if (currentItem == null) {
                return;
            }
            if (!currentItem.hasItemMeta()) {
                return;
            }
            ItemMeta meta = currentItem.getItemMeta();
            if (meta == null) {
                return;
            }
            if (!meta.getPersistentDataContainer().has(Main.inst.itemKey(), PersistentDataType.INTEGER)) {
                return;
            }
            int id = (Integer)meta.getPersistentDataContainer().getOrDefault(Main.inst.itemKey(), PersistentDataType.INTEGER, (Object)-1);
            if (id == -1) {
                return;
            }
            ShopItem shopItem = Main.inst.getSlayerLoader().getShopItem(id);
            if (shopItem == null) {
                return;
            }
            if (data.getShopItemsPurchased().getOrDefault(shopItem.getId(), 0) >= shopItem.getPurchases() && shopItem.getPurchases() != -1) {
                return;
            }
            if (data.getPoints() < shopItem.getCost()) {
                return;
            }
            data.setPoints(data.getPoints() - shopItem.getCost());
            data.getShopItemsPurchased().put(shopItem.getId(), data.getShopItemsPurchased().get(shopItem.getId()) + 1);
            for (String command : shopItem.getCommands()) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command.replace("%player%", event.getWhoClicked().getName()));
            }
            SlayerShopMenu.create(player, data, page).show(event.getWhoClicked());
            event.getWhoClicked().sendMessage(Main.inst.getLanguage().transactionComplete(shopItem.getCost()));
        });
        gui.addPane(pages);
        OutlinePane backgroundPane = new OutlinePane(0, 5, 9, 1);
        backgroundPane.addItem(new GuiItem(background));
        backgroundPane.setRepeat(true);
        backgroundPane.setPriority(Pane.Priority.LOWEST);
        gui.addPane(backgroundPane);
        pages.setPage(page);
        gui.update();
        StaticPane navigation = new StaticPane(0, 5, 9, 1);
        if (page > 0) {
            navigation.addItem(new GuiItem(prevArrow, event -> {
                if (pages.getPage() > 0) {
                    SlayerShopMenu.create(player, data, page - 1).show(event.getWhoClicked());
                }
            }), 6, 0);
        }
        if (pages.getPage() < pages.getPages() - 1) {
            navigation.addItem(new GuiItem(new ItemStack(nextArrow), event -> {
                if (pages.getPage() < pages.getPages() - 1) {
                    SlayerShopMenu.create(player, data, page + 1).show(event.getWhoClicked());
                }
            }), 7, 0);
        }
        if (!(backButtonCommand = Main.inst.getSlayerLoader().getShopBackCommand(player.getName())).equalsIgnoreCase("none")) {
            navigation.addItem(new GuiItem(backButton, event -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), backButtonCommand)), 0, 0);
        }
        navigation.addItem(new GuiItem(points), 4, 0);
        gui.addPane(navigation);
        return gui;
    }
}

